/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;
import team.reborn.energy.api.EnergyStorage;

public class InceptionEnergyStorage
implements EnergyStorage {
    @Nullable
    private final EnergyStorage wrappedEnergyStorage;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;
    private EnergyStorage[] energyStorages;

    public InceptionEnergyStorage(@Nullable EnergyStorage wrappedEnergyStorage, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedEnergyStorage = wrappedEnergyStorage;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlers());
        this.refreshHandlers();
    }

    private void refreshHandlers() {
        ArrayList<EnergyStorage> storages = new ArrayList<EnergyStorage>();
        if (this.wrappedEnergyStorage != null && this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            storages.add(this.wrappedEnergyStorage);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> sbp.getEnergyStorage().ifPresent(storages::add));
        if (this.wrappedEnergyStorage != null && this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            storages.add(this.wrappedEnergyStorage);
        }
        this.energyStorages = storages.toArray(new EnergyStorage[0]);
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        long totalReceived = 0L;
        for (EnergyStorage storage : this.energyStorages) {
            if ((totalReceived += storage.insert(maxAmount - totalReceived, transaction)) == maxAmount) break;
        }
        return totalReceived;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        long totalExtracted = 0L;
        for (EnergyStorage storage : this.energyStorages) {
            if ((totalExtracted += storage.extract(maxAmount - totalExtracted, transaction)) == maxAmount) break;
        }
        return totalExtracted;
    }

    public long getAmount() {
        long totalEnergyStored = 0L;
        for (EnergyStorage storage : this.energyStorages) {
            totalEnergyStored += storage.getAmount();
        }
        return totalEnergyStored;
    }

    public long getCapacity() {
        long totalMaxEnergy = 0L;
        for (EnergyStorage storage : this.energyStorages) {
            if (totalMaxEnergy > Integer.MAX_VALUE - storage.getCapacity()) {
                return Integer.MAX_VALUE;
            }
            totalMaxEnergy += storage.getCapacity();
        }
        return totalMaxEnergy;
    }

    public boolean supportsExtraction() {
        return this.energyStorages.length > 0;
    }

    public boolean supportsInsertion() {
        return this.energyStorages.length > 0;
    }
}

