/*
 * Decompiled with CFR 0.152.
 */
package xyz.ryhon.simpleautoswitch;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1922;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.ryhon.simpleautoswitch.AutoswitchSettingsScreen;

public class SimpleAutoswitch
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"simple-autoswitch");
    public static boolean enabled = true;
    public static boolean requiresAttackHeld = true;
    public static boolean returnToPreviousSlot = true;
    public static boolean sneakToggle = true;
    boolean wasPressed = false;
    public static boolean tempDisabled = false;
    public static int previousSlot = 0;
    int ticks = 0;
    static final int autoSaveTicks = 3600;
    static Path configDir = FabricLoader.getInstance().getConfigDir().resolve("simpleautoswitch");
    static Path configFile = configDir.resolve("config.json");

    public void onInitialize() {
        SimpleAutoswitch.loadConfig();
        String bindCategory = "category.simpleautoswitch";
        class_304 toggleBind = new class_304("key.simpleautoswitch.toggle", class_3675.class_307.field_1668, -1, bindCategory);
        KeyBindingHelper.registerKeyBinding((class_304)toggleBind);
        class_304 menuBind = new class_304("key.simpleautoswitch.menu", class_3675.class_307.field_1668, -1, bindCategory);
        KeyBindingHelper.registerKeyBinding((class_304)menuBind);
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            ++this.ticks;
            if (this.ticks == 3600) {
                this.ticks = 0;
                SimpleAutoswitch.saveConfig();
            }
            if (menuBind.method_1436()) {
                client.method_1507((class_437)new AutoswitchSettingsScreen(null));
            }
            if (toggleBind.method_1436()) {
                enabled = !enabled;
            }
            boolean sw = this.shouldSwitch(client);
            if (!this.wasPressed && sw) {
                tempDisabled = false;
                previousSlot = client.field_1724.method_31548().field_7545;
            }
            if (sw) {
                this.switchToBestSlot(client);
                for (int i = 0; i < client.field_1690.field_1852.length; ++i) {
                    if (!client.field_1690.field_1852[i].method_1434()) continue;
                    tempDisabled = true;
                    previousSlot = i;
                }
            }
            if (this.wasPressed && !sw) {
                if (returnToPreviousSlot) {
                    client.field_1724.method_31548().field_7545 = previousSlot;
                    client.field_1761.method_2911();
                }
                tempDisabled = false;
            }
            this.wasPressed = sw;
        });
    }

    boolean shouldSwitch(class_310 client) {
        if (client.field_1724 == null) {
            return false;
        }
        if (!enabled) {
            return false;
        }
        if (sneakToggle && client.field_1724.method_5715()) {
            return false;
        }
        if (requiresAttackHeld) {
            return client.field_1690.field_1886.method_1434();
        }
        return true;
    }

    void switchToBestSlot(class_310 client) {
        if (client == null || client.field_1724 == null || client.field_1765 == null || tempDisabled) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 p = client.field_1724;
        class_239 hit = client.field_1765;
        if (hit.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHit = (class_3965)hit;
            class_2680 state = world.method_8320(blockHit.method_17777());
            if (state.method_26215()) {
                return;
            }
            int oldSlot = p.method_31548().field_7545;
            int currentSlot = p.method_31548().field_7545;
            float maxDelta = state.method_26165((class_1657)p, (class_1922)p.method_37908(), blockHit.method_17777());
            for (int i = 0; i < class_1661.method_7368(); ++i) {
                p.method_31548().field_7545 = i;
                float delta = state.method_26165((class_1657)p, (class_1922)p.method_37908(), blockHit.method_17777());
                if (!((delta = Math.min(delta, 1.0f)) > maxDelta)) continue;
                maxDelta = delta;
                currentSlot = i;
            }
            p.method_31548().field_7545 = currentSlot;
            if (oldSlot != currentSlot) {
                client.field_1761.method_2911();
            }
        }
    }

    static void loadConfig() {
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            if (!Files.exists(configFile, new LinkOption[0])) {
                return;
            }
            String str = Files.readString(configFile);
            JsonObject jo = (JsonObject)JsonParser.parseString((String)str);
            if (jo.has("enabled")) {
                enabled = jo.get("enabled").getAsBoolean();
            }
            if (jo.has("requiresAttackHeld")) {
                requiresAttackHeld = jo.get("requiresAttackHeld").getAsBoolean();
            }
            if (jo.has("returnToPreviousSlot")) {
                returnToPreviousSlot = jo.get("returnToPreviousSlot").getAsBoolean();
            }
            if (jo.has("sneakToggle")) {
                sneakToggle = jo.get("sneakToggle").getAsBoolean();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config", (Throwable)e);
        }
    }

    static void saveConfig() {
        JsonObject jo = new JsonObject();
        jo.add("enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(enabled)));
        jo.add("requiresAttackHeld", (JsonElement)new JsonPrimitive(Boolean.valueOf(requiresAttackHeld)));
        jo.add("returnToPreviousSlot", (JsonElement)new JsonPrimitive(Boolean.valueOf(returnToPreviousSlot)));
        jo.add("sneakToggle", (JsonElement)new JsonPrimitive(Boolean.valueOf(sneakToggle)));
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            Files.writeString(configFile, (CharSequence)new Gson().toJson((JsonElement)jo), new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }
}

