/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import jeresources.json.WorldGenAdapter;
import jeresources.util.DimensionHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2561;
import net.minecraft.class_5321;

public class ProfilingTimer {
    private final class_2165 sender;
    private int totalChunks;
    private final Map<class_5321<class_1937>, DimensionCounters> dimensionsMap = new HashMap<class_5321<class_1937>, DimensionCounters>();

    public ProfilingTimer(class_2165 sender, int chunkCount) {
        this.sender = sender;
        this.totalChunks = chunkCount;
    }

    public void startChunk(class_5321<class_1937> worldRegistryKey) {
        DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
        if (counters == null) {
            counters = new DimensionCounters();
            this.dimensionsMap.put(worldRegistryKey, counters);
            this.send("[" + DimensionHelper.getDimensionName(worldRegistryKey) + "] Started profiling");
        }
        ++counters.threadCounter;
    }

    public void endChunk(class_5321<class_1937> worldRegistryKey) {
        DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
        --counters.threadCounter;
        if (++counters.chunkCounter % 100 == 0) {
            this.sendSpeed(worldRegistryKey);
        }
        if (this.totalChunks == counters.chunkCounter) {
            counters.completed = true;
        }
    }

    public void complete() {
        for (class_5321<class_1937> worldRegistryKey : this.dimensionsMap.keySet()) {
            DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
            counters.completed = true;
            this.send("[" + DimensionHelper.getDimensionName(worldRegistryKey) + "] Completed profiling of " + this.getBlocksPerLayer(worldRegistryKey) * 256L + " blocks in " + (System.currentTimeMillis() - counters.start) + " ms saved to " + WorldGenAdapter.getWorldGenFile());
        }
    }

    public synchronized boolean isCompleted() {
        for (DimensionCounters counters : this.dimensionsMap.values()) {
            if (counters.completed) continue;
            return false;
        }
        return true;
    }

    private void send(String s) {
        this.sender.method_43496((class_2561)class_2561.method_43471((String)s));
    }

    private void sendSpeed(class_5321<class_1937> worldRegistryKey) {
        DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
        float time = (float)(System.currentTimeMillis() - counters.start) * 1.0f / (float)counters.chunkCounter;
        String message = "[" + DimensionHelper.getDimensionName(worldRegistryKey) + "] Scanned " + counters.chunkCounter + " chunks at " + String.format("%3.2f", Float.valueOf(time)) + " ms/chunk";
        this.send(message);
    }

    public long getBlocksPerLayer(class_5321<class_1937> worldRegistryKey) {
        DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
        return counters.chunkCounter * 16 * 16;
    }

    private static class DimensionCounters {
        public final long start = System.currentTimeMillis();
        public int chunkCounter;
        public int threadCounter;
        public boolean completed;

        private DimensionCounters() {
        }
    }
}

