/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import jeresources.entry.VillagerEntry;
import jeresources.entry.WanderingTraderEntry;
import jeresources.registry.VillagerRegistry;
import jeresources.util.LogHelper;
import net.minecraft.class_2680;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4158;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class VillagersHelper {
    public static void initRegistry(VillagerRegistry reg) {
        for (class_3852 profession : class_7923.field_41195) {
            try {
                reg.addVillagerEntry(new VillagerEntry(profession, VillagersHelper.getTrades(profession)));
            }
            catch (Exception e) {
                LogHelper.warn("Failed loading villager {} registered at {}", profession.toString(), profession.comp_818());
                LogHelper.warn("Exception caught when registering villager", e);
            }
        }
        try {
            reg.addVillagerEntry(new WanderingTraderEntry(VillagersHelper.getWanderingTrades()));
        }
        catch (Exception e) {
            LogHelper.warn("Failed loading wandering trader", new Object[0]);
            LogHelper.warn("Exception caught when registering wandering trader", e);
        }
    }

    private static Int2ObjectMap<class_3853.class_1652[]> getTrades(class_3852 profession) {
        return class_3853.field_17067.getOrDefault(profession, Int2ObjectMaps.emptyMap());
    }

    private static Int2ObjectMap<class_3853.class_1652[]> getWanderingTrades() {
        class_3853.class_1652[] allWanderingTrades = (class_3853.class_1652[])class_3853.field_17724.values().stream().flatMap(x -> Arrays.stream(x)).toArray(class_3853.class_1652[]::new);
        return new Int2ObjectOpenHashMap(new int[]{1}, (Object[])new class_3853.class_1652[][]{allWanderingTrades});
    }

    public static Set<class_2680> getPoiBlocks(class_4158 poiType) {
        return poiType.comp_815();
    }

    public static Set<class_2680> getPoiBlocks(Predicate<class_6880<class_4158>> heldJobSite) {
        return VillagersHelper.getPoiBlocks((class_4158)((class_6880.class_6883)class_7923.field_41128.method_40270().filter(heldJobSite).findFirst().get()).comp_349());
    }
}

