/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.serializer;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1299;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class BreedingSerializer
implements class_1865<BreedingRecipe> {
    @NotNull
    public BreedingRecipe fromJson(@NotNull class_2960 jsonPath, @NotNull JsonObject json) {
        return (BreedingRecipe)Utils.readJsonContents(jsonPath, json, "breeding");
    }

    @NotNull
    public BreedingRecipe fromNetwork(@NotNull class_2960 resourceLocation, @NotNull class_2540 buf) {
        class_2960 entityRL = buf.method_10810();
        class_1299<?> entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(entityRL);
        if (entityType == null) {
            throw new JsonParseException("Unknown EntityType in BreedingRecipe#fromNetwork: " + entityRL);
        }
        class_1856 inputStack = class_1856.method_8086((class_2540)buf);
        class_1856 spawnEgg = class_1856.method_8086((class_2540)buf);
        boolean hasResult = buf.readBoolean();
        class_1856 resultItemStack = hasResult ? class_1856.method_8086((class_2540)buf) : class_1856.field_9017;
        boolean hasExtra = buf.readBoolean();
        class_1856 extraInputStack = hasExtra ? class_1856.method_8086((class_2540)buf) : class_1856.field_9017;
        Boolean needsToBeTamed = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
        Boolean animalTrusting = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
        String jsonModID = buf.method_19772();
        String jsonAnimalID = buf.method_19772();
        String modFolder = buf.method_19772();
        String fileName = buf.method_19772();
        return new BreedingRecipe(entityType, inputStack, spawnEgg, needsToBeTamed, resultItemStack, extraInputStack, animalTrusting, jsonModID, jsonAnimalID, modFolder, fileName);
    }

    public void toNetwork(@NotNull class_2540 buf, @NotNull BreedingRecipe recipe) {
        class_2960 entityKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.entityType);
        if (entityKey == null) {
            throw new JsonParseException("Unknown EntityType in BreedingRecipe: " + recipe.entityType);
        }
        buf.method_10812(entityKey);
        CommonUtils.safe(recipe.inputStack).method_8088(buf);
        CommonUtils.safe(recipe.spawnEgg).method_8088(buf);
        boolean hasResult = recipe.resultItemStack != null && !recipe.resultItemStack.method_8103();
        buf.writeBoolean(hasResult);
        if (hasResult) {
            recipe.resultItemStack.method_8088(buf);
        }
        boolean hasExtra = recipe.extraInputStack != null && !recipe.extraInputStack.method_8103();
        buf.writeBoolean(hasExtra);
        if (hasExtra) {
            recipe.extraInputStack.method_8088(buf);
        }
        if (recipe.needsToBeTamed != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(recipe.needsToBeTamed.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        if (recipe.animalTrusting != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(recipe.animalTrusting.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        buf.method_10814(recipe.jsonModID);
        buf.method_10814(recipe.jsonAnimalID);
        buf.method_10814(recipe.modFolder);
        buf.method_10814(recipe.fileName);
    }
}

