/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_5532;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class Panic<E extends class_1314>
extends ExtendedBehaviour<E> {
    private static final List<Pair<class_4140<?>, class_4141>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)class_4140.field_18451, (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_18445, (Object)class_4141.field_18458), Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18458)});
    protected BiPredicate<E, class_1282> shouldPanicPredicate = (entity, damageSource) -> entity.method_40071() || entity.method_5809() || damageSource.method_5529() instanceof class_1309;
    protected Object2FloatFunction<E> speedMod = entity -> 1.25f;
    protected SquareRadius radius = new SquareRadius(5.0, 4.0);
    protected BiFunction<E, class_1282, Integer> panicFor = (entity, damageSource) -> entity.method_6051().method_43051(100, 120);
    protected class_243 targetPos = null;
    protected int panicEndTime = 0;

    public Panic() {
        this.noTimeout();
    }

    public Panic<E> panicIf(BiPredicate<E, class_1282> predicate) {
        this.shouldPanicPredicate = predicate;
        return this;
    }

    public Panic<E> panicFor(BiFunction<E, class_1282, Integer> function) {
        this.panicFor = function;
        return this;
    }

    public Panic<E> speedMod(Object2FloatFunction<E> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public Panic<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public Panic<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        if (!this.shouldPanicPredicate.test(entity, (class_1282)BrainUtils.getMemory(entity, class_4140.field_18451))) {
            return false;
        }
        this.setPanicTarget(entity);
        return this.targetPos != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return ((class_1314)entity).field_6012 < this.panicEndTime;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, class_4140.field_18445, new class_4142(this.targetPos, ((Float)this.speedMod.apply(entity)).floatValue(), 0));
        BrainUtils.setMemory(entity, class_4140.field_39408, Boolean.valueOf(true));
        this.panicEndTime = ((class_1314)entity).field_6012 + this.panicFor.apply(entity, (class_1282)BrainUtils.getMemory(entity, class_4140.field_18451));
    }

    @Override
    protected void tick(E entity) {
        if (entity.method_5942().method_6357()) {
            this.targetPos = null;
            this.setPanicTarget(entity);
            if (this.targetPos != null) {
                BrainUtils.clearMemory(entity, class_4140.field_18449);
                BrainUtils.setMemory(entity, class_4140.field_18445, new class_4142(this.targetPos, ((Float)this.speedMod.apply(entity)).floatValue(), 1));
            }
        }
    }

    @Override
    protected void stop(E entity) {
        this.targetPos = null;
        this.panicEndTime = 0;
        BrainUtils.setMemory(entity, class_4140.field_39408, Boolean.valueOf(false));
    }

    @Nullable
    protected class_243 findNearbyWater(E entity) {
        class_2338 pos = entity.method_24515();
        class_1937 level = entity.method_37908();
        return !level.method_8320(pos).method_26220((class_1922)level, pos).method_1110() ? null : (class_243)class_2338.method_25997((class_2338)entity.method_24515(), (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), checkPos -> level.method_8316(checkPos).method_15767(class_3486.field_15517)).map(class_243::method_24955).orElse(null);
    }

    protected void setPanicTarget(E entity) {
        if (entity.method_5809()) {
            this.targetPos = this.findNearbyWater(entity);
        }
        if (this.targetPos == null) {
            class_1297 class_12972;
            class_1282 lastDamage = (class_1282)BrainUtils.getMemory(entity, class_4140.field_18451);
            if (lastDamage != null && (class_12972 = lastDamage.method_5529()) instanceof class_1309) {
                class_1309 attacker = (class_1309)class_12972;
                this.targetPos = class_5532.method_31511(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), (class_243)attacker.method_19538());
            }
            if (this.targetPos == null) {
                this.targetPos = class_5532.method_31510(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()));
            }
        }
    }
}

