/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.real;

import com.google.gson.annotations.Expose;
import fr.rakambda.fallingtree.common.config.IConfiguration;
import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.config.enums.SneakMode;
import fr.rakambda.fallingtree.common.config.real.ConfigLoader;
import fr.rakambda.fallingtree.common.config.real.EnchantmentConfiguration;
import fr.rakambda.fallingtree.common.config.real.PlayerConfiguration;
import fr.rakambda.fallingtree.common.config.real.ToolConfiguration;
import fr.rakambda.fallingtree.common.config.real.TreeConfiguration;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Configuration
implements IConfiguration {
    private static final Logger log = LogManager.getLogger(Configuration.class);
    @Expose
    @NotNull
    private TreeConfiguration trees = new TreeConfiguration();
    @Expose
    @NotNull
    private ToolConfiguration tools = new ToolConfiguration();
    @Expose
    @NotNull
    private PlayerConfiguration player = new PlayerConfiguration();
    @Expose
    @NotNull
    private EnchantmentConfiguration enchantment = new EnchantmentConfiguration();
    @Expose
    @NotNull
    private SneakMode sneakMode = SneakMode.SNEAK_DISABLE;
    @Expose
    private boolean breakInCreative = false;
    @Expose
    private boolean lootInCreative = true;
    @Expose
    @NotNull
    private NotificationMode notificationMode = NotificationMode.ACTION_BAR;

    public static Configuration read() throws RuntimeException {
        Path path = Configuration.getConfigPath();
        try {
            return ConfigLoader.loadConfig(new Configuration(), Configuration.class, path);
        }
        catch (IOException e) {
            log.error("Failed to get FallingTree configuration from {}, using default", (Object)path, (Object)e);
            return new Configuration();
        }
    }

    public void onUpdate() {
        this.trees.reset();
        this.tools.reset();
        this.player.reset();
        Path path = Configuration.getConfigPath();
        try {
            ConfigLoader.saveConfig(this, path);
        }
        catch (IOException e) {
            log.error("Failed to save FallingTree configuration to {}", (Object)path, (Object)e);
        }
    }

    private static Path getConfigPath() {
        return Paths.get(".", new String[0]).resolve("config").resolve("fallingtree.json");
    }

    private Configuration() {
    }

    @Override
    @NotNull
    public TreeConfiguration getTrees() {
        return this.trees;
    }

    @Override
    @NotNull
    public ToolConfiguration getTools() {
        return this.tools;
    }

    @Override
    @NotNull
    public PlayerConfiguration getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public EnchantmentConfiguration getEnchantment() {
        return this.enchantment;
    }

    @Override
    @NotNull
    public SneakMode getSneakMode() {
        return this.sneakMode;
    }

    @Override
    public boolean isBreakInCreative() {
        return this.breakInCreative;
    }

    @Override
    public boolean isLootInCreative() {
        return this.lootInCreative;
    }

    @Override
    @NotNull
    public NotificationMode getNotificationMode() {
        return this.notificationMode;
    }

    public void setTrees(@NotNull TreeConfiguration trees) {
        if (trees == null) {
            throw new NullPointerException("trees is marked non-null but is null");
        }
        this.trees = trees;
    }

    public void setTools(@NotNull ToolConfiguration tools) {
        if (tools == null) {
            throw new NullPointerException("tools is marked non-null but is null");
        }
        this.tools = tools;
    }

    public void setPlayer(@NotNull PlayerConfiguration player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
    }

    public void setEnchantment(@NotNull EnchantmentConfiguration enchantment) {
        if (enchantment == null) {
            throw new NullPointerException("enchantment is marked non-null but is null");
        }
        this.enchantment = enchantment;
    }

    public void setSneakMode(@NotNull SneakMode sneakMode) {
        if (sneakMode == null) {
            throw new NullPointerException("sneakMode is marked non-null but is null");
        }
        this.sneakMode = sneakMode;
    }

    public void setBreakInCreative(boolean breakInCreative) {
        this.breakInCreative = breakInCreative;
    }

    public void setLootInCreative(boolean lootInCreative) {
        this.lootInCreative = lootInCreative;
    }

    public void setNotificationMode(@NotNull NotificationMode notificationMode) {
        if (notificationMode == null) {
            throw new NullPointerException("notificationMode is marked non-null but is null");
        }
        this.notificationMode = notificationMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBreakInCreative() != other.isBreakInCreative()) {
            return false;
        }
        if (this.isLootInCreative() != other.isLootInCreative()) {
            return false;
        }
        TreeConfiguration this$trees = this.getTrees();
        TreeConfiguration other$trees = other.getTrees();
        if (this$trees == null ? other$trees != null : !((Object)this$trees).equals(other$trees)) {
            return false;
        }
        ToolConfiguration this$tools = this.getTools();
        ToolConfiguration other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        PlayerConfiguration this$player = this.getPlayer();
        PlayerConfiguration other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        EnchantmentConfiguration this$enchantment = this.getEnchantment();
        EnchantmentConfiguration other$enchantment = other.getEnchantment();
        if (this$enchantment == null ? other$enchantment != null : !((Object)this$enchantment).equals(other$enchantment)) {
            return false;
        }
        SneakMode this$sneakMode = this.getSneakMode();
        SneakMode other$sneakMode = other.getSneakMode();
        if (this$sneakMode == null ? other$sneakMode != null : !((Object)((Object)this$sneakMode)).equals((Object)other$sneakMode)) {
            return false;
        }
        NotificationMode this$notificationMode = this.getNotificationMode();
        NotificationMode other$notificationMode = other.getNotificationMode();
        return !(this$notificationMode == null ? other$notificationMode != null : !((Object)((Object)this$notificationMode)).equals((Object)other$notificationMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBreakInCreative() ? 79 : 97);
        result = result * 59 + (this.isLootInCreative() ? 79 : 97);
        TreeConfiguration $trees = this.getTrees();
        result = result * 59 + ($trees == null ? 43 : ((Object)$trees).hashCode());
        ToolConfiguration $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        PlayerConfiguration $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : ((Object)$player).hashCode());
        EnchantmentConfiguration $enchantment = this.getEnchantment();
        result = result * 59 + ($enchantment == null ? 43 : ((Object)$enchantment).hashCode());
        SneakMode $sneakMode = this.getSneakMode();
        result = result * 59 + ($sneakMode == null ? 43 : ((Object)((Object)$sneakMode)).hashCode());
        NotificationMode $notificationMode = this.getNotificationMode();
        result = result * 59 + ($notificationMode == null ? 43 : ((Object)((Object)$notificationMode)).hashCode());
        return result;
    }

    public String toString() {
        return "Configuration(trees=" + this.getTrees() + ", tools=" + this.getTools() + ", player=" + this.getPlayer() + ", enchantment=" + this.getEnchantment() + ", sneakMode=" + this.getSneakMode() + ", breakInCreative=" + this.isBreakInCreative() + ", lootInCreative=" + this.isLootInCreative() + ", notificationMode=" + this.getNotificationMode() + ")";
    }
}

