/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.screen.entries;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.enums.LoadType;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigListWidgetEntry;
import net.pneumono.pneumonocore.config_api.screen.widgets.ConfigsListWidget;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractConfigurationEntry<T, C extends AbstractConfiguration<T>>
extends AbstractConfigListWidgetEntry {
    protected final ConfigsListWidget widget;
    protected final C configuration;
    protected final class_344 resetWidget;
    protected T value;

    public AbstractConfigurationEntry(ConfigOptionsScreen parent, ConfigsListWidget widget, C configuration) {
        super(parent);
        this.widget = widget;
        this.configuration = configuration;
        this.resetWidget = this.addChild(new class_344(0, 0, 20, 20, 0, 0, 20, PneumonoCore.identifier("textures/gui/sprites/icon/reset_button.png"), 20, 40, button -> this.reset()));
        this.resetWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"configs_screen.pneumonocore.reset")));
        this.value = this.parent.getConfigValue(this.configuration);
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.widget.updateEntryList();
        this.updateWidgets();
    }

    public void reset() {
        this.setValue(((AbstractConfiguration)this.configuration).info().getDefaultValue());
    }

    @Override
    public boolean shouldDisplay() {
        AbstractConfiguration<?> configParent = ((AbstractConfiguration)this.configuration).info().getParent();
        if (configParent == null) {
            return true;
        }
        AbstractConfigurationEntry<?, ?> configParentEntry = this.widget.getEntry(configParent.info().getId());
        if (configParentEntry == null) {
            return true;
        }
        return ((AbstractConfiguration)this.configuration).info().isEnabled(configParentEntry.value);
    }

    public int getWidgetStartX() {
        return this.getRowEndXOffset() - 136;
    }

    public int getWidgetEndX() {
        return this.getRowEndXOffset() - this.resetWidget.method_25368() - 6;
    }

    public int getTotalWidgetWidth() {
        return this.getWidgetEndX() - this.getWidgetStartX();
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
        class_5250 configName = class_2561.method_43471((String)ConfigApi.toTranslationKey(this.configuration));
        class_327 textRenderer = Objects.requireNonNull(this.parent.getClient()).field_1772;
        context.method_27535(textRenderer, (class_2561)configName, x, y + entryHeight / 2 - 2, -1);
        if (mouseX >= x && mouseX <= x + 135 && mouseY >= y && mouseY <= y + entryHeight) {
            class_5250 class_52502 = class_2561.method_43471((String)ConfigApi.toTranslationKey(this.configuration, "tooltip")).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)(((AbstractConfiguration)this.configuration).info().isClientSided() ? "configs_screen.pneumonocore.client" : "configs_screen.pneumonocore.server")).method_27692(class_124.field_1080)).method_27693("\n");
            context.method_51447(textRenderer, textRenderer.method_1728((class_5348)class_52502.method_10852((class_2561)class_2561.method_43471((String)(switch (((AbstractConfiguration)this.configuration).info().getLoadType()) {
                default -> throw new IncompatibleClassChangeError();
                case LoadType.INSTANT -> "configs_screen.pneumonocore.load_instant";
                case LoadType.RELOAD -> "configs_screen.pneumonocore.load_reload";
                case LoadType.RESTART -> "configs_screen.pneumonocore.load_restart";
            })).method_27692(class_124.field_1080)), 250), mouseX, mouseY);
        }
        this.resetWidget.method_46421(x + this.getRowEndXOffset() - this.resetWidget.method_25368());
        this.resetWidget.method_46419(y);
        this.resetWidget.method_25394(context, mouseX, mouseY, tickProgress);
    }

    public boolean shouldSaveValue() {
        return true;
    }
}

