/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

public class AnimatedTileEntity
extends class_2586 {
    private static final String NBT_ANIM_NAME = "animName";
    private JsonContainer.Entry meta;
    private BBModel model;
    private BBModelParts.Animation animation;
    private String animationName;
    private double timer = 0.0;
    private long lastUpdateTime = 0L;
    private final Map<UUID, Map<BBModelParts.Channel, float[]>> keyframeCache = new HashMap<UUID, Map<BBModelParts.Channel, float[]>>();
    private final float[] tempRotation = new float[3];
    private final float[] tempPosition = new float[3];
    private final float[] tempScale = new float[3];
    private final Map<UUID, Map<BBModelParts.Channel, List<BBModelParts.Keyframe>>> sortedKeyframeCache = new HashMap<UUID, Map<BBModelParts.Channel, List<BBModelParts.Keyframe>>>();
    private boolean keyframeCacheValid = false;

    public AnimatedTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        if (state.method_26204() instanceof DecoAnimatedBlock) {
            DecoAnimatedBlock animatedBlock = (DecoAnimatedBlock)state.method_26204();
            this.meta = animatedBlock.meta;
            this.model = animatedBlock.model;
            if (this.meta != null && this.meta.default_animation != null) {
                this.setAnimationName(this.meta.default_animation);
            } else if (this.model != null && this.model.animationPerName != null && !this.model.animationPerName.isEmpty()) {
                String firstAnimation = this.model.animationPerName.keySet().iterator().next();
                this.setAnimationName(firstAnimation);
            }
        } else {
            this.meta = null;
            this.model = null;
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545(NBT_ANIM_NAME)) {
            String newAnimName = nbt.method_10558(NBT_ANIM_NAME);
            this.setAnimationName(newAnimName);
        }
    }

    public class_2591<?> method_11017() {
        class_2591<AnimatedTileEntity> currentType = super.method_11017();
        return currentType != null ? currentType : ModuleTileEntities.ANIMATED_TE;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.animationName != null) {
            nbt.method_10582(NBT_ANIM_NAME, this.animationName);
        }
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void tick() {
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public void setAnimationName(String animName) {
        boolean animationChanged;
        if (animName == null) {
            String string = animName = this.meta != null ? this.meta.default_animation : "animation.default";
        }
        if (this.model != null && this.model.animationPerName != null && !this.model.animationPerName.isEmpty()) {
            if (Objects.equals(animName, "any")) {
                availableAnimations = this.model.animationPerName.keySet().toArray(new String[0]);
                animName = availableAnimations[new Random().nextInt(availableAnimations.length)];
            } else if (Objects.equals(animName, "any_other")) {
                availableAnimations = this.model.animationPerName.keySet().toArray(new String[0]);
                if (availableAnimations.length > 1) {
                    String newAnimName = null;
                    while (Objects.equals(newAnimName = availableAnimations[new Random().nextInt(availableAnimations.length)], this.animationName) || Objects.equals(newAnimName, "any_other")) {
                    }
                    animName = newAnimName;
                } else {
                    animName = availableAnimations[0];
                }
            }
        }
        boolean bl = animationChanged = !Objects.equals(animName, this.animationName);
        if (animationChanged) {
            this.timer = 0.0;
            this.keyframeCacheValid = false;
        }
        this.animationName = animName;
        this.method_5431();
        if (this.model != null && this.model.animationPerName != null) {
            this.animation = this.model.animationPerName.get(animName);
        }
        if (animationChanged && animName != null) {
            this.onAnimationStart();
        }
    }

    private void buildSortedKeyframeCache() {
        if (this.keyframeCacheValid || this.animation == null) {
            return;
        }
        this.sortedKeyframeCache.clear();
        for (Map.Entry<UUID, BBModelParts.Animator> animator : this.animation.animators.entrySet()) {
            UUID key = animator.getKey();
            List<BBModelParts.Keyframe> keyframes = animator.getValue().keyframes;
            Map channelMap = this.sortedKeyframeCache.computeIfAbsent(key, k -> new EnumMap(BBModelParts.Channel.class));
            for (BBModelParts.Channel channel : BBModelParts.Channel.values()) {
                ArrayList<BBModelParts.Keyframe> channelKeyframes = new ArrayList<BBModelParts.Keyframe>();
                for (BBModelParts.Keyframe keyframe : keyframes) {
                    if (keyframe.channel != channel) continue;
                    channelKeyframes.add(keyframe);
                }
                channelKeyframes.sort(Comparator.comparing(k -> Float.valueOf(k.time)));
                channelMap.put(channel, channelKeyframes);
            }
        }
        this.keyframeCacheValid = true;
    }

    private BBModelParts.Keyframe findKeyframe(List<BBModelParts.Keyframe> sortedKeyframes, double time, boolean findLower) {
        if (sortedKeyframes.isEmpty()) {
            return null;
        }
        int left = 0;
        int right = sortedKeyframes.size() - 1;
        BBModelParts.Keyframe result = null;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            BBModelParts.Keyframe keyframe = sortedKeyframes.get(mid);
            if (findLower) {
                if ((double)keyframe.time < time) {
                    result = keyframe;
                    left = mid + 1;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if ((double)keyframe.time >= time) {
                result = keyframe;
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return result;
    }

    public double getTimer() {
        return this.timer;
    }

    public void updateTimer() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
            return;
        }
        double deltaTime = (double)(currentTime - this.lastUpdateTime) / 1000.0;
        this.lastUpdateTime = currentTime;
        double previousTimer = this.timer;
        this.timer += deltaTime;
        if (this.animation != null && this.animation.length > 0.0f && previousTimer < (double)this.animation.length && this.timer >= (double)this.animation.length) {
            this.onAnimationEnd();
        }
    }

    @Deprecated
    public void addTimer(float timer) {
        this.timer += (double)timer;
    }

    public Map<UUID, Map<BBModelParts.Channel, float[]>> getKeyframes() {
        this.keyframeCache.clear();
        if (this.animation == null) {
            return this.keyframeCache;
        }
        if (this.animation.length == 0.0f) {
            if (this.animation.animators == null || this.animation.animators.isEmpty()) {
                return this.keyframeCache;
            }
            this.timer = 0.0;
        }
        this.buildSortedKeyframeCache();
        double timer = this.animation.length > 0.0f ? this.timer % (double)this.animation.length : 0.0;
        for (Map.Entry<UUID, Map<BBModelParts.Channel, List<BBModelParts.Keyframe>>> entry : this.sortedKeyframeCache.entrySet()) {
            UUID key = entry.getKey();
            Map<BBModelParts.Channel, List<BBModelParts.Keyframe>> channelKeyframes = entry.getValue();
            Map channelMap = this.keyframeCache.computeIfAbsent(key, k -> new EnumMap(BBModelParts.Channel.class));
            for (BBModelParts.Channel channel : BBModelParts.Channel.values()) {
                List<BBModelParts.Keyframe> sortedKeyframes = channelKeyframes.get((Object)channel);
                if (sortedKeyframes == null || sortedKeyframes.isEmpty()) {
                    if (channel == BBModelParts.Channel.ROTATION) {
                        this.tempRotation[0] = 0.0f;
                        this.tempRotation[1] = 0.0f;
                        this.tempRotation[2] = 0.0f;
                        channelMap.put(channel, (float[])this.tempRotation.clone());
                        continue;
                    }
                    if (channel == BBModelParts.Channel.POSITION) {
                        this.tempPosition[0] = 0.0f;
                        this.tempPosition[1] = 0.0f;
                        this.tempPosition[2] = 0.0f;
                        channelMap.put(channel, (float[])this.tempPosition.clone());
                        continue;
                    }
                    if (channel != BBModelParts.Channel.SCALE) continue;
                    this.tempScale[0] = 1.0f;
                    this.tempScale[1] = 1.0f;
                    this.tempScale[2] = 1.0f;
                    channelMap.put(channel, (float[])this.tempScale.clone());
                    continue;
                }
                BBModelParts.Keyframe lowKeyframe = this.findKeyframe(sortedKeyframes, timer, true);
                BBModelParts.Keyframe highKeyframe = this.findKeyframe(sortedKeyframes, timer, false);
                if (lowKeyframe == null || highKeyframe == null) {
                    BBModelParts.Keyframe singleKeyframe;
                    BBModelParts.Keyframe keyframe = singleKeyframe = lowKeyframe != null ? lowKeyframe : highKeyframe;
                    if (singleKeyframe != null) {
                        BBModelParts.DataPoint data = singleKeyframe.data_points.get(0);
                        float[] values = channelMap.computeIfAbsent(channel, k -> new float[3]);
                        values[0] = data.x;
                        values[1] = data.y;
                        values[2] = data.z;
                        continue;
                    }
                    if (channel == BBModelParts.Channel.ROTATION) {
                        this.tempRotation[0] = 0.0f;
                        this.tempRotation[1] = 0.0f;
                        this.tempRotation[2] = 0.0f;
                        channelMap.put(channel, (float[])this.tempRotation.clone());
                        continue;
                    }
                    if (channel == BBModelParts.Channel.POSITION) {
                        this.tempPosition[0] = 0.0f;
                        this.tempPosition[1] = 0.0f;
                        this.tempPosition[2] = 0.0f;
                        channelMap.put(channel, (float[])this.tempPosition.clone());
                        continue;
                    }
                    if (channel != BBModelParts.Channel.SCALE) continue;
                    this.tempScale[0] = 1.0f;
                    this.tempScale[1] = 1.0f;
                    this.tempScale[2] = 1.0f;
                    channelMap.put(channel, (float[])this.tempScale.clone());
                    continue;
                }
                BBModelParts.DataPoint low = lowKeyframe.data_points.get(0);
                BBModelParts.DataPoint high = highKeyframe.data_points.get(0);
                if (lowKeyframe == highKeyframe) {
                    float[] values = channelMap.computeIfAbsent(channel, k -> new float[3]);
                    values[0] = low.x;
                    values[1] = low.y;
                    values[2] = low.z;
                    continue;
                }
                float factor = ((float)timer - lowKeyframe.time) / (highKeyframe.time - lowKeyframe.time);
                float[] values = channelMap.computeIfAbsent(channel, k -> new float[3]);
                values[0] = this.lerp(low.x, high.x, factor);
                values[1] = this.lerp(low.y, high.y, factor);
                values[2] = this.lerp(low.z, high.z, factor);
            }
        }
        return this.keyframeCache;
    }

    private float lerp(float start, float end, float factor) {
        return start + factor * (end - start);
    }

    public void cycleAnimation() {
        if (this.meta == null || this.meta.script == null || this.meta.script.on_use == null || this.meta.script.on_use.animations == null) {
            return;
        }
        String currentAnimation = this.getAnimationName();
        if (currentAnimation == null) {
            currentAnimation = this.meta.default_animation;
        }
        String fromAnimation = currentAnimation;
        Optional<JsonContainer.Animation> nextTransition = this.meta.script.on_use.animations.stream().filter(anim -> Objects.equals(anim.from, fromAnimation)).findFirst();
        if (!nextTransition.isPresent()) {
            nextTransition = this.meta.script.on_use.animations.stream().findFirst();
        }
        if (nextTransition.isPresent()) {
            String nextAnimation = nextTransition.get().to;
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.setAnimationName(nextAnimation);
                this.method_5431();
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            } else {
                this.setAnimationName(nextAnimation);
            }
        }
    }

    private void onAnimationEnd() {
        if (this.meta == null || this.meta.script == null || this.meta.script.animation_end == null) {
            return;
        }
        if (this.meta.script.animation_end.animations != null) {
            String currentAnimation = this.getAnimationName();
            if (currentAnimation == null) {
                currentAnimation = this.meta.default_animation;
            }
            String fromAnimation = currentAnimation;
            Optional<JsonContainer.Animation> nextTransition = this.meta.script.animation_end.animations.stream().filter(anim -> Objects.equals(anim.from, fromAnimation) || Objects.equals(anim.from, "any")).findFirst();
            if (nextTransition.isPresent()) {
                String nextAnimation = nextTransition.get().to;
                if (this.field_11863 != null && !this.field_11863.field_9236) {
                    this.setAnimationName(nextAnimation);
                    this.method_5431();
                    this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                } else {
                    this.setAnimationName(nextAnimation);
                }
            }
        }
    }

    private void onAnimationStart() {
        if (this.meta == null || this.meta.script == null || this.meta.script.animation_start == null) {
            return;
        }
        if (this.meta.script.animation_start.animations != null) {
            String currentAnimation = this.getAnimationName();
            if (currentAnimation == null) {
                currentAnimation = this.meta.default_animation;
            }
            String fromAnimation = currentAnimation;
            Optional<JsonContainer.Animation> nextTransition = this.meta.script.animation_start.animations.stream().filter(anim -> Objects.equals(anim.from, fromAnimation) || Objects.equals(anim.from, "any")).findFirst();
            if (nextTransition.isPresent()) {
                String nextAnimation = nextTransition.get().to;
                if (this.field_11863 != null && !this.field_11863.field_9236) {
                    this.setAnimationName(nextAnimation);
                    this.method_5431();
                    this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                } else {
                    this.setAnimationName(nextAnimation);
                }
            }
        }
    }
}

