/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class SlotItemHandler<T extends SlottedStorage<ItemVariant>>
extends class_1735 {
    private static final class_1263 emptyInventory = new class_1277(0);
    private final T slottedStackStorage;
    private final int index;

    public SlotItemHandler(T slottedStorage, int slot, int x, int y) {
        super(emptyInventory, slot, x, y);
        this.slottedStackStorage = slottedStorage;
        this.index = slot;
    }

    public T getItemHandler() {
        return this.slottedStackStorage;
    }

    public class_1799 method_7677() {
        T t = this.slottedStackStorage;
        if (t instanceof SlottedStackStorage) {
            SlottedStackStorage storage = (SlottedStackStorage)t;
            return storage.getStackInSlot(this.index);
        }
        SingleSlotStorage slot = this.slottedStackStorage.getSlot(this.index);
        return ((ItemVariant)slot.getResource()).toStack((int)slot.getAmount());
    }

    public void method_7673(class_1799 stack) {
        ItemVariant resource;
        T t = this.slottedStackStorage;
        if (t instanceof SlottedStackStorage) {
            SlottedStackStorage storage = (SlottedStackStorage)t;
            storage.setStackInSlot(this.index, stack);
            this.method_7668();
            return;
        }
        SingleSlotStorage slot = this.slottedStackStorage.getSlot(this.index);
        if (!slot.isResourceBlank()) {
            try (Transaction extract = Transaction.openOuter();){
                this.slottedStackStorage.extract((Object)((ItemVariant)slot.getResource()), slot.getAmount(), (TransactionContext)extract);
                extract.commit();
            }
        }
        if (!(resource = ItemVariant.of((class_1799)stack)).isBlank()) {
            try (Transaction insert = Transaction.openOuter();){
                this.slottedStackStorage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)insert);
                insert.commit();
            }
        }
        this.method_7668();
    }

    public class_1799 method_7671(int amount) {
        long extracted;
        T t = this.slottedStackStorage;
        if (t instanceof SlottedStackStorage) {
            SlottedStackStorage storage = (SlottedStackStorage)t;
            class_1799 stack = storage.getStackInSlot(this.index).method_7972();
            class_1799 removed = stack.method_7971(amount);
            storage.setStackInSlot(this.index, stack);
            return removed;
        }
        SingleSlotStorage slot = this.slottedStackStorage.getSlot(this.index);
        try (Transaction extract = Transaction.openOuter();){
            extracted = this.slottedStackStorage.extract((Object)((ItemVariant)slot.getResource()), (long)amount, (TransactionContext)extract);
            extract.commit();
        }
        return ((ItemVariant)slot.getResource()).toStack((int)extracted);
    }

    public boolean method_7680(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        T t = this.slottedStackStorage;
        if (t instanceof SlottedStackStorage) {
            SlottedStackStorage storage = (SlottedStackStorage)t;
            return storage.isItemValid(this.index, ItemVariant.of((class_1799)stack), stack.method_7947());
        }
        return true;
    }

    public boolean method_7674(class_1657 player) {
        T t = this.slottedStackStorage;
        if (t instanceof SlottedStackStorage) {
            SlottedStackStorage storage = (SlottedStackStorage)t;
            return !storage.getStackInSlot(this.index).method_7960();
        }
        return !this.slottedStackStorage.getSlot(this.index).isResourceBlank();
    }

    public int method_7675() {
        T t = this.slottedStackStorage;
        if (t instanceof SlottedStackStorage) {
            SlottedStackStorage storage = (SlottedStackStorage)t;
            return storage.getSlotLimit(this.index);
        }
        return (int)this.slottedStackStorage.getSlot(this.index).getCapacity();
    }

    public int method_7676(class_1799 stack) {
        int maxSize;
        T t = this.slottedStackStorage;
        if (t instanceof SlottedStackStorage) {
            SlottedStackStorage storage = (SlottedStackStorage)t;
            maxSize = storage.getSlotLimit(this.index);
        } else {
            maxSize = (int)this.slottedStackStorage.getSlot(this.index).getCapacity();
        }
        return Math.min(stack.method_7914(), maxSize);
    }

    public void method_7670(class_1799 oldStack, class_1799 newStack) {
    }
}

