/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.feeding;

import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.HungerLevel;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FeedingUpgradeContainer
extends UpgradeContainerBase<FeedingUpgradeWrapper, FeedingUpgradeContainer> {
    private static final String DATA_HUNGER_LEVEL = "hungerLevel";
    private static final String DATA_FEED_IMMEDIATELY_WHEN_HURT = "feedImmediatelyWhenHurt";
    private final FilterLogicContainer<FilterLogic> filterLogicContainer = new FilterLogicContainer<FilterLogic>(() -> ((FeedingUpgradeWrapper)this.upgradeWrapper).getFilterLogic(), this, this.slots::add);

    public FeedingUpgradeContainer(class_1657 player, int containerId, FeedingUpgradeWrapper wrapper, UpgradeContainerType<FeedingUpgradeWrapper, FeedingUpgradeContainer> type) {
        super(player, containerId, wrapper, type);
    }

    @Override
    public void handleMessage(class_2487 data) {
        if (data.method_10545(DATA_HUNGER_LEVEL)) {
            this.setFeedAtHungerLevel(HungerLevel.fromName(data.method_10558(DATA_HUNGER_LEVEL)));
        } else if (data.method_10545(DATA_FEED_IMMEDIATELY_WHEN_HURT)) {
            this.setFeedImmediatelyWhenHurt(data.method_10577(DATA_FEED_IMMEDIATELY_WHEN_HURT));
        }
        this.filterLogicContainer.handleMessage(data);
    }

    public FilterLogicContainer<FilterLogic> getFilterLogicContainer() {
        return this.filterLogicContainer;
    }

    public void setFeedAtHungerLevel(HungerLevel hungerLevel) {
        ((FeedingUpgradeWrapper)this.upgradeWrapper).setFeedAtHungerLevel(hungerLevel);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new class_2487(), DATA_HUNGER_LEVEL, hungerLevel));
    }

    public HungerLevel getFeedAtHungerLevel() {
        return ((FeedingUpgradeWrapper)this.upgradeWrapper).getFeedAtHungerLevel();
    }

    public void setFeedImmediatelyWhenHurt(boolean feedImmediatelyWhenHurt) {
        ((FeedingUpgradeWrapper)this.upgradeWrapper).setFeedImmediatelyWhenHurt(feedImmediatelyWhenHurt);
        this.sendBooleanToServer(DATA_FEED_IMMEDIATELY_WHEN_HURT, feedImmediatelyWhenHurt);
    }

    public boolean shouldFeedImmediatelyWhenHurt() {
        return ((FeedingUpgradeWrapper)this.upgradeWrapper).shouldFeedImmediatelyWhenHurt();
    }
}

