/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ISlotLimitUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class VoidUpgradeWrapper
extends UpgradeWrapperBase<VoidUpgradeWrapper, VoidUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade,
ISlotLimitUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private boolean shouldVoidOverflow;

    public VoidUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((VoidUpgradeItem)this.upgradeItem).getFilterSlotCount());
        this.filterLogic.setAllowByDefault(true);
        this.setShouldVoidOverflowDefaultOrLoadFromNbt(false);
    }

    @Override
    public long onBeforeInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
        class_1799 stack = resource.toStack((int)maxAmount);
        if (this.shouldVoidOverflow && inventoryHandler.getStackInSlot(slot).method_7960() && (!this.filterLogic.shouldMatchNbt() || !this.filterLogic.shouldMatchDurability() || this.filterLogic.getPrimaryMatch() != PrimaryMatch.ITEM) && this.filterLogic.matchesFilter(stack)) {
            for (int s = 0; s < inventoryHandler.getSlotCount(); ++s) {
                if (s == slot || !this.stackMatchesFilterStack(inventoryHandler.getStackInSlot(s), stack)) continue;
                return 0L;
            }
            return maxAmount;
        }
        return !this.shouldVoidOverflow && this.filterLogic.matchesFilter(stack) ? 0L : maxAmount;
    }

    @Override
    public void onAfterInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, @Nullable TransactionContext ctx) {
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean(this.upgrade, "shouldWorkInGUI", shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean(this.upgrade, "shouldWorkInGUI").orElse(false);
    }

    public void setShouldVoidOverflow(boolean shouldVoidOverflow) {
        if (!shouldVoidOverflow && !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled()) {
            return;
        }
        this.shouldVoidOverflow = shouldVoidOverflow;
        NBTHelper.setBoolean(this.upgrade, "shouldVoidOverflow", shouldVoidOverflow);
        this.save();
    }

    public void setShouldVoidOverflowDefaultOrLoadFromNbt(boolean shouldVoidOverflowDefault) {
        this.shouldVoidOverflow = !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || NBTHelper.getBoolean(this.upgrade, "shouldVoidOverflow").orElse(shouldVoidOverflowDefault) != false;
    }

    public boolean shouldVoidOverflow() {
        return !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || this.shouldVoidOverflow;
    }

    @Override
    public void onSlotChange(SlottedStackStorage inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.shouldVoidOverflow()) {
            return;
        }
        class_1799 slotStack = inventoryHandler.getStackInSlot(slot);
        if (!slotStack.method_7960() && this.filterLogic.matchesFilter(slotStack)) {
            this.slotsToVoid.add(slot);
        }
    }

    @Override
    public void tick(@Nullable class_1297 entity, class_1937 world, class_2338 pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            class_1799 stack = storageInventory.getStackInSlot(slot);
            if (stack.method_7960()) continue;
            Transaction outer = Transaction.openOuter();
            try {
                storageInventory.extractSlot(slot, ItemVariant.of((class_1799)stack), stack.method_7947(), (TransactionContext)outer);
                outer.commit();
            }
            finally {
                if (outer == null) continue;
                outer.close();
            }
        }
        this.slotsToVoid.clear();
    }

    @Override
    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @Override
    public class_1799 onOverflow(class_1799 stack) {
        return this.filterLogic.matchesFilter(stack) ? class_1799.field_8037 : stack;
    }

    @Override
    public boolean stackMatchesFilter(class_1799 stack) {
        return this.filterLogic.matchesFilter(stack);
    }

    public boolean isVoidAnythingEnabled() {
        return ((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled();
    }

    @Override
    public int getSlotLimit() {
        return Integer.MAX_VALUE;
    }
}

