/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.discovery;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.impl.discovery.ModCandidate;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.fabricmc.loader.impl.discovery.ModSolver;
import net.fabricmc.loader.impl.discovery.ResultAnalyzer;
import net.fabricmc.loader.impl.metadata.ModDependencyImpl;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import reloc.org.sat4j.specs.ContradictionException;
import reloc.org.sat4j.specs.TimeoutException;

public class ModResolver {
    private static final Comparator<ModCandidate> modPrioComparator = new Comparator<ModCandidate>(){

        @Override
        public int compare(ModCandidate a, ModCandidate b) {
            int idCmp;
            if (a.isRoot()) {
                if (!b.isRoot()) {
                    return -1;
                }
            } else if (b.isRoot()) {
                return 1;
            }
            if ((idCmp = a.getId().compareTo(b.getId())) != 0) {
                return idCmp;
            }
            int versionCmp = b.getVersion().compareTo(a.getVersion());
            if (versionCmp != 0) {
                return versionCmp;
            }
            int nestCmp = a.getMinNestLevel() - b.getMinNestLevel();
            if (nestCmp != 0) {
                return nestCmp;
            }
            if (a.isRoot()) {
                return 0;
            }
            ArrayList<ModCandidate> parents = new ArrayList<ModCandidate>(a.getParentMods().size() + b.getParentMods().size());
            parents.addAll(a.getParentMods());
            parents.addAll(b.getParentMods());
            parents.sort(this);
            if (a.getParentMods().contains(parents.get(0))) {
                if (b.getParentMods().contains(parents.get(0))) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }
    };

    public static List<ModCandidate> resolve(Collection<ModCandidate> candidates, EnvType envType, Map<String, Set<ModCandidate>> envDisabledMods) throws ModResolutionException {
        long startTime = System.nanoTime();
        List<ModCandidate> result = ModResolver.findCompatibleSet(candidates, envType, envDisabledMods);
        long endTime = System.nanoTime();
        Log.debug(LogCategory.RESOLUTION, "Mod resolution time: %.1f ms", (double)(endTime - startTime) * 1.0E-6);
        return result;
    }

    private static List<ModCandidate> findCompatibleSet(Collection<ModCandidate> candidates, EnvType envType, Map<String, Set<ModCandidate>> envDisabledMods) throws ModResolutionException {
        ModCandidate modCandidate;
        ModSolver.Result result;
        ArrayList<ModCandidate> allModsSorted = new ArrayList<ModCandidate>(candidates);
        allModsSorted.sort(modPrioComparator);
        LinkedHashMap<String, List<ModCandidate>> modsById = new LinkedHashMap<String, List<ModCandidate>>();
        for (ModCandidate modCandidate2 : allModsSorted) {
            modsById.computeIfAbsent(modCandidate2.getId(), ignore -> new ArrayList()).add(modCandidate2);
            for (String provided : modCandidate2.getProvides()) {
                modsById.computeIfAbsent(provided, ignore -> new ArrayList()).add(modCandidate2);
            }
        }
        for (ModCandidate modCandidate3 : allModsSorted) {
            if (modCandidate3.getMetadata().getSchemaVersion() >= 2) continue;
            block5: for (ModDependency dep : modCandidate3.getMetadata().getDependencies()) {
                Collection collection;
                if (!dep.getKind().isPositive() || dep.getKind() == ModDependency.Kind.SUGGESTS || !(dep instanceof ModDependencyImpl) || modsById.containsKey(dep.getModId()) || (collection = (Collection)envDisabledMods.get(dep.getModId())) == null) continue;
                for (Object m : collection) {
                    if (!dep.matches(((ModCandidate)m).getVersion())) continue;
                    ((ModDependencyImpl)dep).setKind(ModDependency.Kind.SUGGESTS);
                    continue block5;
                }
            }
        }
        ArrayList preselectedMods = new ArrayList();
        for (List mods : modsById.values()) {
            Object builtinMod = null;
            for (ModCandidate modCandidate4 : mods) {
                if (!modCandidate4.isBuiltin()) continue;
                builtinMod = modCandidate4;
                break;
            }
            if (builtinMod == null) continue;
            if (mods.size() > 1) {
                mods.remove(builtinMod);
                throw new ModResolutionException("Mods share ID with builtin mod %s: %s", builtinMod, mods);
            }
            preselectedMods.add(builtinMod);
        }
        HashMap<String, ModCandidate> hashMap = new HashMap<String, ModCandidate>(allModsSorted.size());
        ArrayList<ModCandidate> uniqueSelectedMods = new ArrayList<ModCandidate>(allModsSorted.size());
        for (ModCandidate modCandidate5 : preselectedMods) {
            ModResolver.preselectMod(modCandidate5, allModsSorted, modsById, hashMap, uniqueSelectedMods);
        }
        try {
            result = ModSolver.solve(allModsSorted, modsById, hashMap, uniqueSelectedMods);
        }
        catch (ContradictionException | TimeoutException exception) {
            throw new ModResolutionException("Solving failed", exception);
        }
        if (!result.success) {
            Log.warn(LogCategory.RESOLUTION, "Mod resolution failed");
            Log.info(LogCategory.RESOLUTION, "Immediate reason: %s%n", result.immediateReason);
            Log.info(LogCategory.RESOLUTION, "Reason: %s%n", result.reason);
            if (!envDisabledMods.isEmpty()) {
                Log.info(LogCategory.RESOLUTION, "%s environment disabled: %s%n", envType.name(), envDisabledMods.keySet());
            }
            if (result.fix == null) {
                Log.info(LogCategory.RESOLUTION, "No fix?");
            } else {
                Log.info(LogCategory.RESOLUTION, "Fix: add %s, remove %s, replace [%s]%n", result.fix.modsToAdd, result.fix.modsToRemove, result.fix.modReplacements.entrySet().stream().map(e -> String.format("%s -> %s", e.getValue(), e.getKey())).collect(Collectors.joining(", ")));
                for (Collection collection : envDisabledMods.values()) {
                    for (ModCandidate m2 : collection) {
                        result.fix.inactiveMods.put(m2, ModSolver.InactiveReason.WRONG_ENVIRONMENT);
                    }
                }
            }
            throw new ModResolutionException("Some of your mods are incompatible with the game or each other!%s", ResultAnalyzer.gatherErrors(result, hashMap, modsById, envDisabledMods, envType));
        }
        uniqueSelectedMods.sort(Comparator.comparing(ModCandidate::getId));
        ArrayDeque<ModCandidate> arrayDeque = new ArrayDeque<ModCandidate>();
        for (ModCandidate mod5 : allModsSorted) {
            if (hashMap.get(mod5.getId()) == mod5) {
                if (mod5.resetMinNestLevel()) continue;
                arrayDeque.add(mod5);
                continue;
            }
            mod5.clearCachedData();
            for (ModCandidate m3 : mod5.getNestedMods()) {
                m3.getParentMods().remove(mod5);
            }
            for (ModCandidate m : mod5.getParentMods()) {
                m.getNestedMods().remove(mod5);
            }
        }
        while ((modCandidate = (ModCandidate)arrayDeque.poll()) != null) {
            for (ModCandidate child : modCandidate.getNestedMods()) {
                if (!child.updateMinNestLevel(modCandidate)) continue;
                arrayDeque.add(child);
            }
        }
        String string = ResultAnalyzer.gatherWarnings(uniqueSelectedMods, hashMap, envDisabledMods, envType);
        if (string != null) {
            Log.warn(LogCategory.RESOLUTION, "Warnings were found!%s", string);
        }
        return uniqueSelectedMods;
    }

    static void preselectMod(ModCandidate mod, List<ModCandidate> allModsSorted, Map<String, List<ModCandidate>> modsById, Map<String, ModCandidate> selectedMods, List<ModCandidate> uniqueSelectedMods) throws ModResolutionException {
        ModResolver.selectMod(mod, selectedMods, uniqueSelectedMods);
        allModsSorted.removeAll((Collection)modsById.remove(mod.getId()));
        for (String provided : mod.getProvides()) {
            allModsSorted.removeAll((Collection)modsById.remove(provided));
        }
    }

    static void selectMod(ModCandidate mod, Map<String, ModCandidate> selectedMods, List<ModCandidate> uniqueSelectedMods) throws ModResolutionException {
        ModCandidate prev = selectedMods.put(mod.getId(), mod);
        if (prev != null) {
            throw new ModResolutionException("duplicate mod %s", mod.getId());
        }
        for (String provided : mod.getProvides()) {
            prev = selectedMods.put(provided, mod);
            if (prev == null) continue;
            throw new ModResolutionException("duplicate mod %s", provided);
        }
        uniqueSelectedMods.add(mod);
    }
}

