/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.loader;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import net.minecraftforge.forgespi.language.IModInfo;
import org.sinytra.connector.ConnectorUtil;
import org.sinytra.connector.locator.ConnectorConfig;
import org.slf4j.Logger;

public class ConnectorEarlyLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> CONNECTOR_MODIDS = new HashSet<String>();
    private static final List<IModInfo> CONNECTOR_MODS = new ArrayList<IModInfo>();
    private static final List<EarlyLoadingException> LOADING_EXCEPTIONS = new ArrayList<EarlyLoadingException>();

    public static boolean isConnectorMod(String modid) {
        return CONNECTOR_MODIDS.contains(modid);
    }

    public static List<IModInfo> getConnectorMods() {
        return CONNECTOR_MODS;
    }

    public static List<EarlyLoadingException> getLoadingExceptions() {
        return LOADING_EXCEPTIONS;
    }

    public static boolean hasEncounteredException() {
        return !LOADING_EXCEPTIONS.isEmpty() || LoadingModList.get() != null && !LoadingModList.get().getErrors().isEmpty();
    }

    public static void addGenericLoadingException(Throwable t, String message) {
        ConnectorEarlyLoader.addGenericLoadingException(ConnectorEarlyLoader.createGenericLoadingException(t, message));
    }

    public static void addGenericLoadingException(EarlyLoadingException exception) {
        if (LoadingModList.get() != null) {
            LoadingModList.get().getErrors().add(exception);
        } else {
            LOADING_EXCEPTIONS.add(exception);
        }
    }

    public static EarlyLoadingException createGenericLoadingException(Throwable original, String message) {
        return ConnectorEarlyLoader.createLoadingException(original, "\u00a7e[Connector]\u00a7r {3}\n\u00a7c{4}\u00a77: {5}\u00a7r", true, message, original.getClass().getName(), original.getMessage());
    }

    public static EarlyLoadingException createLoadingException(Throwable original, String message, boolean keepOriginal, Object ... args) {
        return new EarlyLoadingException(ConnectorUtil.stripColor(original.getMessage()), keepOriginal ? original : null, List.of(new EarlyLoadingException.ExceptionData(message, args)));
    }

    public static void init() {
        if (ConnectorEarlyLoader.hasEncounteredException()) {
            LOGGER.error("Skipping early mod setup due to previous error");
            return;
        }
        LOGGER.debug("Starting early connector loader setup");
        ProgressMeter progress = StartupNotificationManager.addProgressBar((String)"[Connector] Early Setup", (int)0);
        try {
            List<String> hiddenMods = ConnectorConfig.INSTANCE.get().hiddenMods();
            List<ModInfo> mods = LoadingModList.get().getMods().stream().filter(mod -> {
                if (mod.getOwningFile().getFileProperties().containsKey("connector_transformed")) {
                    CONNECTOR_MODIDS.add(mod.getModId());
                    CONNECTOR_MODS.add((IModInfo)mod);
                    return true;
                }
                return !hiddenMods.contains(mod.getModId());
            }).toList();
            FabricLoaderImpl.INSTANCE.addFmlMods(mods);
        }
        catch (Throwable t) {
            LOGGER.error("Encountered error during early mod setup", t);
            ConnectorEarlyLoader.addGenericLoadingException(t, "Encountered an error during early mod setup");
        }
        progress.complete();
    }

    public static void setup() {
        try {
            FabricLoaderImpl.INSTANCE.setup();
        }
        catch (Throwable t) {
            LOGGER.error("Encountered an error during fabric loader setup", t);
            ConnectorEarlyLoader.addGenericLoadingException(t, "Encountered an error during fabric loader setup");
        }
    }

    public static void preLaunch() {
        LOGGER.debug("Running prelaunch entrypoint");
        ProgressMeter progress = StartupNotificationManager.addProgressBar((String)"[Connector] PreLaunch", (int)0);
        try {
            FabricLoader.getInstance().invokeEntrypoints("preLaunch", PreLaunchEntrypoint.class, PreLaunchEntrypoint::onPreLaunch);
        }
        catch (Throwable t) {
            LOGGER.error("Encountered an error in prelaunch entrypoint", t);
            ConnectorEarlyLoader.addGenericLoadingException(t, "Encountered an error in prelaunch entrypoint");
        }
        progress.complete();
    }
}

