/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.jar;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.ClassTransformer;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.coremod.CoreModProvider;
import net.minecraftforge.fml.loading.moddiscovery.CoreModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import net.minecraftforge.forgespi.coremod.ICoreModFile;
import net.minecraftforge.forgespi.locating.IModFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import reloc.net.minecraftforge.fart.api.ClassProvider;

public class EarlyJSCoremodTransformer
implements ClassProvider {
    private static final MethodHandle GET_CORE_MODS = (MethodHandle)LamdbaExceptionUtils.uncheck(() -> MethodHandles.privateLookupIn(ModFileParser.class, MethodHandles.lookup()).findStatic(ModFileParser.class, "getCoreMods", MethodType.methodType(List.class, ModFile.class)));
    private static final MethodHandle TRANSFORM = (MethodHandle)LamdbaExceptionUtils.uncheck(() -> MethodHandles.privateLookupIn(ClassTransformer.class, MethodHandles.lookup()).findVirtual(ClassTransformer.class, "transform", MethodType.methodType(byte[].class, byte[].class, String.class, String.class)));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ClassProvider provider;
    private final ClassTransformer transformer;

    public static EarlyJSCoremodTransformer create(ClassProvider classProvider, Iterable<IModFile> loadedMods) {
        try {
            CoreModProvider provider = new CoreModProvider();
            for (IModFile mf : loadedMods) {
                List list = GET_CORE_MODS.invoke((ModFile)mf);
                if (list.isEmpty()) continue;
                for (CoreModFile f : list) {
                    provider.addCoreMod((ICoreModFile)f);
                }
            }
            List transformers = provider.getCoreModTransformers();
            TransformStore transformStore = new TransformStore();
            DummyService service = new DummyService(transformers);
            Constructor cst = TransformationServiceDecorator.class.getDeclaredConstructor(ITransformationService.class);
            cst.setAccessible(true);
            TransformationServiceDecorator decorator = (TransformationServiceDecorator)cst.newInstance(service);
            decorator.gatherTransformers(transformStore);
            LaunchPluginHandler plugins = (LaunchPluginHandler)UnsafeHacks.newInstance(LaunchPluginHandler.class);
            Field pluginsField = LaunchPluginHandler.class.getDeclaredField("plugins");
            pluginsField.setAccessible(true);
            pluginsField.set(plugins, new HashMap());
            Constructor xformCst = ClassTransformer.class.getDeclaredConstructor(TransformStore.class, LaunchPluginHandler.class, TransformingClassLoader.class);
            xformCst.setAccessible(true);
            ClassTransformer classTransformer = (ClassTransformer)xformCst.newInstance(transformStore, plugins, null);
            return new EarlyJSCoremodTransformer(classProvider, classTransformer);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public EarlyJSCoremodTransformer(ClassProvider provider, ClassTransformer transformer) {
        this.provider = provider;
        this.transformer = transformer;
    }

    @Override
    public Optional<? extends ClassProvider.IClassInfo> getClass(String s) {
        return this.provider.getClass(s);
    }

    @Override
    public Optional<byte[]> getClassBytes(String s) {
        return this.provider.getClassBytes(s).map(bytes -> {
            try {
                return TRANSFORM.invoke(this.transformer, (byte[])bytes, s, "computing_frames");
            }
            catch (Throwable t) {
                LOGGER.error("Error transforming class " + s, t);
                return bytes;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.provider.close();
    }

    private record DummyService(List transformers) implements ITransformationService
    {
        @NotNull
        public String name() {
            return "connector_early_js_coremods";
        }

        public void initialize(IEnvironment environment) {
        }

        public void onLoad(IEnvironment env, Set<String> otherServices) {
        }
    }
}

