/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.blocks;

import de.lucalabs.fairylights.blocks.entity.LightBlockEntity;
import de.lucalabs.fairylights.items.DyeableItem;
import de.lucalabs.fairylights.items.LightVariant;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class LightBlock
extends class_2341
implements class_2343 {
    public static final class_2746 LIT = class_2741.field_12548;
    private static final class_265 MIN_ANCHOR_SHAPE = class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private final class_265 floorShape;
    private final class_265 eastWallShape;
    private final class_265 westWallShape;
    private final class_265 northWallShape;
    private final class_265 southWallShape;
    private final class_265 ceilingShape;
    private final LightVariant<?> variant;

    public LightBlock(class_4970.class_2251 properties, LightVariant<?> variant) {
        super(properties);
        this.variant = variant;
        class_238 bb = this.variant.getBounds();
        double w = Math.max(bb.method_17939(), bb.method_17941());
        double w0 = 0.5 - w * 0.5;
        double w1 = 0.5 + w * 0.5;
        if (variant.isOrientable()) {
            this.floorShape = LightBlock.clampBox(w0, 0.0, w0, w1, -bb.field_1322, w1);
            this.eastWallShape = LightBlock.clampBox(0.0, w0, w0, -bb.field_1322, w1, w1);
            this.westWallShape = LightBlock.clampBox(1.0 + bb.field_1322, w0, w0, 1.0, w1, w1);
            this.southWallShape = LightBlock.clampBox(w0, w0, 0.0, w1, w1, -bb.field_1322);
            this.northWallShape = LightBlock.clampBox(w0, w0, 1.0 + bb.field_1322, w1, w1, 1.0);
            this.ceilingShape = LightBlock.clampBox(w0, 1.0 + bb.field_1322, w0, w1, 1.0, w1);
        } else {
            double t = 0.125;
            double u = 0.6875;
            this.floorShape = LightBlock.clampBox(w0, 0.0, w0, w1, bb.method_17940() - this.variant.getFloorOffset(), w1);
            this.eastWallShape = LightBlock.clampBox(w0 - 0.125, 0.6875 + bb.field_1322, w0, w1 - 0.125, 0.6875 + bb.field_1325, w1);
            this.westWallShape = LightBlock.clampBox(w0 + 0.125, 0.6875 + bb.field_1322, w0, w1 + 0.125, 0.6875 + bb.field_1325, w1);
            this.southWallShape = LightBlock.clampBox(w0, 0.6875 + bb.field_1322, w0 - 0.125, w1, 0.6875 + bb.field_1325, w1 - 0.125);
            this.northWallShape = LightBlock.clampBox(w0, 0.6875 + bb.field_1322, w0 + 0.125, w1, 0.6875 + bb.field_1325, w1 + 0.125);
            this.ceilingShape = LightBlock.clampBox(w0, 1.0 + bb.field_1322 - 0.25, w0, w1, 1.0, w1);
        }
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true)));
    }

    private static class_265 clampBox(double x0, double y0, double z0, double x1, double y1, double z1) {
        return class_259.method_1081((double)class_3532.method_15350((double)x0, (double)0.0, (double)1.0), (double)class_3532.method_15350((double)y0, (double)0.0, (double)1.0), (double)class_3532.method_15350((double)z0, (double)0.0, (double)1.0), (double)class_3532.method_15350((double)x1, (double)0.0, (double)1.0), (double)class_3532.method_15350((double)y1, (double)0.0, (double)1.0), (double)class_3532.method_15350((double)z1, (double)0.0, (double)1.0));
    }

    public LightVariant<?> getVariant() {
        return this.variant;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LightBlockEntity(pos, state);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2738 value = (class_2738)state.method_11654((class_2769)field_11007);
        if (value == class_2738.field_12471) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
            class_2338 anchorPos = pos.method_10093(facing.method_10153());
            class_2680 anchorState = world.method_8320(anchorPos);
            if (anchorState.method_26164(class_3481.field_15503)) {
                return true;
            }
            class_265 shape = anchorState.method_26222((class_1922)world, anchorPos);
            return class_2248.method_9501((class_265)shape, (class_2350)facing);
        }
        class_2350 facing = value == class_2738.field_12475 ? class_2350.field_11033 : class_2350.field_11036;
        class_2338 anchorPos = pos.method_10093(facing);
        class_2680 anchorState = world.method_8320(anchorPos);
        if (anchorState.method_26164(class_3481.field_15503)) {
            return true;
        }
        class_265 shape = anchorState.method_26222((class_1922)world, anchorPos);
        return !class_259.method_1074((class_265)shape.method_20538(facing.method_10153()), (class_265)MIN_ANCHOR_SHAPE, (class_247)class_247.field_16893);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        for (class_2350 dir : context.method_7718()) {
            class_2680 state = dir.method_10166() == class_2350.class_2351.field_11052 ? (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11007, (Comparable)(dir == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475))).method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153()) : (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)field_11177, (Comparable)dir.method_10153());
            if (!state.method_26184((class_4538)context.method_8045(), context.method_8037())) continue;
            return state;
        }
        return null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof LightBlockEntity) {
            class_1799 lightItem = stack.method_7972();
            lightItem.method_7939(1);
            ((LightBlockEntity)entity).setItemStack(lightItem);
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 entity = (class_2586)builder.method_51876(class_181.field_1228);
        if (entity instanceof LightBlockEntity) {
            return Collections.singletonList(((LightBlockEntity)entity).getLight().getItem().method_7972());
        }
        return Collections.emptyList();
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof LightBlockEntity) {
            ((LightBlockEntity)entity).interact(world, pos, state, player, hand, hit);
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rng) {
        super.method_9496(state, world, pos, rng);
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof LightBlockEntity) {
            ((LightBlockEntity)entity).animateTick();
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2738)state.method_11654((class_2769)field_11007)) {
            case class_2738.field_12471 -> {
                switch ((class_2350)state.method_11654((class_2769)field_11177)) {
                    case field_11039: {
                        yield this.westWallShape;
                    }
                    case field_11035: {
                        yield this.southWallShape;
                    }
                    case field_11043: {
                        yield this.northWallShape;
                    }
                }
                yield this.eastWallShape;
            }
            case class_2738.field_12473 -> this.ceilingShape;
            default -> this.floorShape;
        };
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof LightBlockEntity) {
            return ((LightBlockEntity)entity).getLight().getItem().method_7972();
        }
        class_1799 stack = new class_1799((class_1935)this);
        DyeableItem.setColor(stack, class_1767.field_7947);
        return stack;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11007, field_11177, LIT});
    }
}

