/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.collision;

import de.lucalabs.fairylights.collision.Collidable;
import de.lucalabs.fairylights.collision.Intersection;
import de.lucalabs.fairylights.feature.Feature;
import de.lucalabs.fairylights.feature.FeatureType;
import de.lucalabs.fairylights.util.MathHelper;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public final class FeatureCollisionTree
implements Collidable {
    private final FeatureType type;
    public final class_238[] tree;
    private final Feature[] nodeToFeature;

    private FeatureCollisionTree(FeatureType type, class_238[] tree, Feature[] nodeToFeature) {
        this.type = type;
        this.tree = tree;
        this.nodeToFeature = nodeToFeature;
    }

    @Override
    @Nullable
    public Intersection intersect(class_243 origin, class_243 end) {
        return this.intersect(origin, end, 0);
    }

    @Nullable
    private Intersection intersect(class_243 origin, class_243 end, int node) {
        class_243 result = this.tree[node].method_1006(origin) ? origin : (class_243)this.tree[node].method_992(origin, end).orElse(null);
        if (result == null) {
            return null;
        }
        int nL = node * 2 + 1;
        if (nL >= this.tree.length || this.tree[nL] == null) {
            return new Intersection(result, this.tree[node], this.type, this.nodeToFeature[node]);
        }
        Intersection intersection = this.intersect(origin, end, nL);
        if (intersection != null) {
            return intersection;
        }
        return this.intersect(origin, end, node * 2 + 2);
    }

    public static <T extends Feature> FeatureCollisionTree build(FeatureType type, T[] features, Function<T, class_238> mapper) {
        return FeatureCollisionTree.build((FeatureType)type, features, mapper, (int)0, (int)(features.length - 1));
    }

    public static <T extends Feature> FeatureCollisionTree build(FeatureType type, T[] features, Function<T, class_238> mapper, int start, int end) {
        return FeatureCollisionTree.build(type, i -> features[i], (int i) -> (class_238)mapper.apply(features[i]), start, end);
    }

    public static <T extends Feature> FeatureCollisionTree build(FeatureType type, IntFunction<T> features, IntFunction<class_238> mapper, int start, int end) {
        class_238[] tree = new class_238[end == 0 ? 1 : (1 << MathHelper.log2(end - start) + 2) - 1];
        Feature[] treeFeatures = new Feature[tree.length];
        tree[0] = FeatureCollisionTree.build(features, mapper, tree, treeFeatures, start, end, 0);
        return new FeatureCollisionTree(type, tree, treeFeatures);
    }

    private static <T extends Feature> class_238 build(IntFunction<T> features, IntFunction<class_238> mapper, class_238[] tree, Feature[] treeFeatures, int min, int max, int node) {
        if (min > max) {
            throw new IllegalStateException(String.format("min > max, tree: %s, min: %d, max: %d, node: %d", Arrays.toString(tree), min, max, node));
        }
        if (min == max) {
            treeFeatures[node] = (Feature)features.apply(min);
            return mapper.apply(min);
        }
        int mid = min + (max - min) / 2;
        int nL = node * 2 + 1;
        int nR = node * 2 + 2;
        tree[nL] = FeatureCollisionTree.build(features, mapper, tree, treeFeatures, min, mid, nL);
        tree[nR] = FeatureCollisionTree.build(features, mapper, tree, treeFeatures, mid + 1, max, nR);
        return tree[nL].method_991(tree[nR]);
    }
}

