/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.connection;

import de.lucalabs.fairylights.collision.Collidable;
import de.lucalabs.fairylights.collision.CollidableList;
import de.lucalabs.fairylights.collision.FeatureCollisionTree;
import de.lucalabs.fairylights.connection.ConnectionType;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.fastener.FastenerType;
import de.lucalabs.fairylights.fastener.FenceFastener;
import de.lucalabs.fairylights.fastener.accessor.FastenerAccessor;
import de.lucalabs.fairylights.feature.Feature;
import de.lucalabs.fairylights.feature.FeatureType;
import de.lucalabs.fairylights.items.ConnectionItem;
import de.lucalabs.fairylights.sounds.FairyLightSounds;
import de.lucalabs.fairylights.util.Catenary;
import de.lucalabs.fairylights.util.CubicBezier;
import de.lucalabs.fairylights.util.Curve;
import de.lucalabs.fairylights.util.Curve3D;
import de.lucalabs.fairylights.util.ItemHelper;
import de.lucalabs.fairylights.util.NbtSerializable;
import de.lucalabs.fairylights.util.Utils;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public abstract class Connection
implements NbtSerializable {
    public static final int MAX_LENGTH = 32;
    public static final double PULL_RANGE = 5.0;
    public static final float MAX_SLACK = 3.0f;
    public static final FeatureType CORD_FEATURE = FeatureType.register("cord");
    private static final CubicBezier SLACK_CURVE = new CubicBezier(0.495f, 0.505f, 0.495f, 0.505f);
    protected final Fastener<?> fastener;
    private final ConnectionType<?> type;
    private final UUID uuid;
    protected class_1937 world;
    @Nullable
    protected Curve prevCatenary;
    protected float slack = 1.0f;
    private FastenerAccessor destination;
    @Nullable
    private FastenerAccessor prevDestination;
    @Nullable
    private Curve catenary;
    private Collidable collision = Collidable.empty();
    private boolean updateCatenary;
    private int prevStretchStage;
    private boolean removed;
    private boolean drop;

    public Connection(ConnectionType<?> type, class_1937 world, Fastener<?> fastener, UUID uuid) {
        this.type = type;
        this.world = world;
        this.fastener = fastener;
        this.uuid = uuid;
        this.computeCatenary();
    }

    public ConnectionType<?> getType() {
        return this.type;
    }

    @Nullable
    public final Curve getCatenary() {
        return this.catenary;
    }

    @Nullable
    public final Curve getPrevCatenary() {
        return this.prevCatenary == null ? this.catenary : this.prevCatenary;
    }

    public final class_1937 getWorld() {
        return this.world;
    }

    public void setWorld(class_1937 world) {
        this.world = world;
    }

    public final Collidable getCollision() {
        return this.collision;
    }

    public final Fastener<?> getFastener() {
        return this.fastener;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final FastenerAccessor getDestination() {
        return this.destination;
    }

    public final void setDestination(Fastener<?> destination) {
        this.prevDestination = this.destination;
        this.destination = destination.createAccessor();
        this.computeCatenary();
    }

    public boolean isDestination(FastenerAccessor location) {
        return this.destination.equals(location);
    }

    public void setDrop() {
        this.drop = true;
    }

    public void noDrop() {
        this.drop = false;
    }

    public boolean shouldDrop() {
        return this.drop;
    }

    public class_1799 getItemStack() {
        class_1799 stack = new class_1799((class_1935)this.getType().getItem());
        class_2487 tagCompound = this.serializeLogic();
        if (!tagCompound.method_33133()) {
            stack.method_7980(tagCompound);
        }
        return stack;
    }

    public float getRadius() {
        return 0.0625f;
    }

    public final boolean isDynamic() {
        return this.fastener.isMoving() || this.destination.get(this.world, false).filter(Fastener::isMoving).isPresent();
    }

    public final boolean isModifiable(class_1657 player) {
        return this.world.method_8505(player, this.fastener.getPos());
    }

    public final void remove() {
        if (!this.removed) {
            this.removed = true;
            this.onRemove();
        }
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public void computeCatenary() {
        this.updateCatenary = true;
    }

    public void disconnect(class_1657 player, class_243 hit) {
        this.destination.get(this.world).ifPresent(f -> this.disconnect((Fastener<?>)f, hit));
    }

    private void disconnect(Fastener<?> destinationFastener, class_243 hit) {
        this.fastener.removeConnection(this);
        destinationFastener.removeConnection(this.uuid);
        if (this.shouldDrop()) {
            class_1799 stack = this.getItemStack();
            class_1542 item = new class_1542(this.world, hit.field_1352, hit.field_1351, hit.field_1350, stack);
            float scale = 0.05f;
            item.method_18800(this.world.field_9229.method_43059() * (double)0.05f, this.world.field_9229.method_43059() * (double)0.05f + (double)0.2f, this.world.field_9229.method_43059() * (double)0.05f);
            this.world.method_8649((class_1297)item);
        }
        this.world.method_43128(null, hit.field_1352, hit.field_1351, hit.field_1350, FairyLightSounds.CORD_DISCONNECT, class_3419.field_15245, 1.0f, 1.0f);
    }

    public boolean reconnect(Fastener<?> destination) {
        return this.fastener.reconnect(this.world, this, destination);
    }

    public boolean interact(class_1657 player, class_243 hit, FeatureType featureType, int feature, class_1799 heldStack, class_1268 hand) {
        class_1792 item = heldStack.method_7909();
        if (item instanceof ConnectionItem && !this.matches(heldStack)) {
            return this.replace(player, hit, heldStack);
        }
        if (heldStack.method_31574(class_1802.field_8276)) {
            return this.slacken(hit, heldStack, 0.2f);
        }
        if (heldStack.method_31574(class_1802.field_8600)) {
            return this.slacken(hit, heldStack, -0.2f);
        }
        return false;
    }

    public boolean matches(class_1799 stack) {
        if (this.getType().getItem().equals(stack.method_7909())) {
            class_2487 tag = stack.method_7969();
            return tag == null || Utils.impliesNbt((class_2520)this.serializeLogic(), (class_2520)tag);
        }
        return false;
    }

    private boolean replace(class_1657 player, class_243 hit, class_1799 heldStack) {
        return this.destination.get(this.world).map(dest -> {
            this.fastener.removeConnection(this);
            dest.removeConnection(this.uuid);
            if (this.shouldDrop()) {
                ItemHelper.giveItemToPlayer(player, this.getItemStack());
            }
            class_2487 data = heldStack.method_7969();
            ConnectionType<?> type = ((ConnectionItem)heldStack.method_7909()).getConnectionType();
            Connection conn = this.fastener.connect(this.world, (Fastener<?>)dest, type, data == null ? new class_2487() : data, true);
            conn.slack = this.slack;
            conn.onConnect(player.method_37908(), player, heldStack);
            heldStack.method_7934(1);
            this.world.method_43128(null, hit.field_1352, hit.field_1351, hit.field_1350, FairyLightSounds.CORD_CONNECT, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }).orElse(false);
    }

    private boolean slacken(class_243 hit, class_1799 heldStack, float amount) {
        if (this.slack <= 0.0f && amount < 0.0f || this.slack >= 3.0f && amount > 0.0f) {
            return true;
        }
        this.slack = class_3532.method_15363((float)(this.slack + amount), (float)0.0f, (float)3.0f);
        if (this.slack < 0.01f) {
            this.slack = 0.0f;
        }
        this.computeCatenary();
        this.world.method_43128(null, hit.field_1352, hit.field_1351, hit.field_1350, FairyLightSounds.CORD_STRETCH, class_3419.field_15245, 1.0f, 0.8f + (3.0f - this.slack) * 0.4f);
        return true;
    }

    public void onConnect(class_1937 world, class_1657 user, class_1799 heldStack) {
    }

    protected void onRemove() {
    }

    protected void onUpdate() {
    }

    protected void onCalculateCatenary(boolean relocated) {
    }

    public final boolean update(class_243 from) {
        this.prevCatenary = this.catenary;
        boolean changed = this.destination.get(this.world, false).map(dest -> {
            class_243 point = dest.getConnectionPoint();
            boolean c = this.updateCatenary(from, (Fastener<?>)dest, point);
            this.onUpdate();
            double dist = point.method_1022(from);
            double pull = dist - 32.0 + 5.0;
            if (pull > 0.0) {
                int stage = (int)(pull + (double)0.1f);
                if (stage > this.prevStretchStage) {
                    this.world.method_43128(null, point.field_1352, point.field_1351, point.field_1350, FairyLightSounds.CORD_STRETCH, class_3419.field_15245, 0.25f, 0.5f + (float)stage / 8.0f);
                }
                this.prevStretchStage = stage;
            }
            if (dist > 37.0) {
                this.world.method_43128(null, point.field_1352, point.field_1351, point.field_1350, FairyLightSounds.CORD_SNAP, class_3419.field_15245, 0.75f, 0.8f + this.world.field_9229.method_43057() * 0.3f);
                this.remove();
            } else if (dest.isMoving()) {
                dest.resistSnap(from);
            }
            return c;
        }).orElse(false);
        if (this.destination.isGone(this.world)) {
            this.remove();
        }
        return changed;
    }

    private boolean updateCatenary(class_243 from, Fastener<?> dest, class_243 point) {
        if (this.updateCatenary || this.isDynamic()) {
            class_243 vec = point.method_1020(from);
            if (vec.method_1033() > 1.0E-6) {
                class_2350 facing = this.fastener.getFacing();
                this.catenary = this.fastener instanceof FenceFastener && dest instanceof FenceFastener && vec.method_37267() < 0.01 ? this.verticalHelix(vec) : Catenary.from(vec, facing.method_10166() == class_2350.class_2351.field_11052 ? 0.0f : (float)Math.toRadians(90.0f + facing.method_10144()), SLACK_CURVE, this.slack);
                this.onCalculateCatenary(!this.destination.equals(this.prevDestination));
                CollidableList.Builder bob = new CollidableList.Builder();
                this.addCollision(bob, from);
                this.collision = bob.build();
            }
            this.updateCatenary = false;
            this.prevDestination = this.destination;
            return true;
        }
        return false;
    }

    private Curve verticalHelix(class_243 vec) {
        float length = (float)vec.method_1033();
        float height = (float)vec.field_1351;
        float stepSize = 0.25f;
        float loopsPerBlock = 1.0f;
        float radius = 0.33f;
        int steps = (int)(2.0734513f * length / 0.25f);
        float rad = (float)Math.PI * -2 * (1.0f * length);
        float[] x = new float[steps];
        float[] y = new float[steps];
        float[] z = new float[steps];
        float helixLength = 0.0f;
        for (int i = 0; i < steps; ++i) {
            float t = (float)i / (float)(steps - 1);
            x[i] = 0.33f * class_3532.method_15362((float)(t * rad));
            y[i] = t * height;
            z[i] = 0.33f * class_3532.method_15374((float)(t * rad));
            if (i <= 0) continue;
            helixLength += class_3532.method_15355((float)(class_3532.method_27285((float)(x[i] - x[i - 1])) + class_3532.method_27285((float)(y[i] - y[i - 1])) + class_3532.method_27285((float)(z[i] - z[i - 1]))));
        }
        return new Curve3D(steps, x, y, z, helixLength);
    }

    public void addCollision(CollidableList.Builder collision, class_243 origin) {
        if (this.catenary == null) {
            return;
        }
        int count = this.catenary.getCount();
        if (count <= 2) {
            return;
        }
        float r = this.getRadius();
        Curve.SegmentIterator it = this.catenary.iterator();
        class_238[] bounds = new class_238[count - 1];
        int index = 0;
        while (it.next()) {
            float x0 = it.getX(0.0f);
            float y0 = it.getY(0.0f);
            float z0 = it.getZ(0.0f);
            float x1 = it.getX(1.0f);
            float y1 = it.getY(1.0f);
            float z1 = it.getZ(1.0f);
            bounds[index++] = new class_238(origin.field_1352 + (double)x0, origin.field_1351 + (double)y0, origin.field_1350 + (double)z0, origin.field_1352 + (double)x1, origin.field_1351 + (double)y1, origin.field_1350 + (double)z1).method_1014((double)r);
        }
        collision.add(FeatureCollisionTree.build(CORD_FEATURE, i -> Segment.INSTANCE, i -> bounds[i], 1, bounds.length - 2));
    }

    public void deserialize(Fastener<?> destination, class_2487 compound, boolean drop) {
        this.destination = destination.createAccessor();
        this.drop = drop;
        this.deserializeLogic(compound);
    }

    @Override
    public class_2487 serialize() {
        class_2487 compound = new class_2487();
        compound.method_10566("destination", (class_2520)FastenerType.serialize(this.destination));
        compound.method_10566("logic", (class_2520)this.serializeLogic());
        compound.method_10548("slack", this.slack);
        if (!this.drop) {
            compound.method_10556("drop", false);
        }
        return compound;
    }

    @Override
    public void deserialize(class_2487 compound) {
        this.destination = FastenerType.deserialize(compound.method_10562("destination"));
        this.deserializeLogic(compound.method_10562("logic"));
        this.slack = compound.method_10573("slack", 99) ? compound.method_10583("slack") : 1.0f;
        this.drop = !compound.method_10573("drop", 99) || compound.method_10577("drop");
        this.updateCatenary = true;
    }

    public class_2487 serializeLogic() {
        return new class_2487();
    }

    public void deserializeLogic(class_2487 compound) {
    }

    static class Segment
    implements Feature {
        static final Segment INSTANCE = new Segment();

        Segment() {
        }

        @Override
        public int getId() {
            return 0;
        }
    }
}

