/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.connection;

import de.lucalabs.fairylights.collision.CollidableList;
import de.lucalabs.fairylights.collision.FeatureCollisionTree;
import de.lucalabs.fairylights.connection.Connection;
import de.lucalabs.fairylights.connection.ConnectionType;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.feature.FeatureType;
import de.lucalabs.fairylights.feature.HangingFeature;
import de.lucalabs.fairylights.util.BoxBuilder;
import de.lucalabs.fairylights.util.Curve;
import de.lucalabs.fairylights.util.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;

public abstract class HangingFeatureConnection<F extends HangingFeature>
extends Connection {
    protected static final FeatureType FEATURE = FeatureType.register("feature");
    protected F[] features = this.createFeatures(0);

    public HangingFeatureConnection(ConnectionType<? extends HangingFeatureConnection<F>> type, class_1937 world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    public final F[] getFeatures() {
        return this.features;
    }

    @Override
    protected void onCalculateCatenary(boolean relocated) {
        this.updateFeatures(relocated);
    }

    protected void updateFeatures(boolean relocated) {
        Curve catenary = this.getCatenary();
        float spacing = this.getFeatureSpacing();
        float totalLength = catenary.getLength();
        if (totalLength > 64.0f) {
            this.onBeforeUpdateFeatures();
            this.features = this.createFeatures(0);
            this.onAfterUpdateFeatures();
            return;
        }
        F[] prev = this.features;
        ArrayList features = new ArrayList();
        this.onBeforeUpdateFeatures();
        catenary.visitPoints(spacing, true, (index, x, y, z, yaw, pitch) -> {
            Object feature;
            if (!relocated && prev != null && index < prev.length && this.canReuse(prev[index], index)) {
                feature = prev[index];
                ((HangingFeature)feature).set(new class_243((double)x, (double)y, (double)z), yaw, pitch);
            } else {
                feature = this.createFeature(index, new class_243((double)x, (double)y, (double)z), yaw, pitch);
            }
            this.updateFeature(feature);
            features.add(feature);
        });
        this.features = features.toArray(this.createFeatures(features.size()));
        this.onAfterUpdateFeatures();
    }

    protected boolean canReuse(F feature, int index) {
        return true;
    }

    protected abstract F[] createFeatures(int var1);

    protected abstract F createFeature(int var1, class_243 var2, float var3, float var4);

    protected abstract float getFeatureSpacing();

    protected void onBeforeUpdateFeatures() {
    }

    protected void updateFeature(F feature) {
    }

    protected void onAfterUpdateFeatures() {
    }

    @Override
    public void addCollision(CollidableList.Builder collision, class_243 origin) {
        super.addCollision(collision, origin);
        if (this.features.length > 0) {
            MatrixStack matrix = new MatrixStack();
            collision.add(FeatureCollisionTree.build((FeatureType)FEATURE, this.features, f -> {
                class_243[] verts;
                class_243 pos = f.getPoint();
                double x = origin.field_1352 + pos.field_1352;
                double y = origin.field_1351 + pos.field_1351;
                double z = origin.field_1350 + pos.field_1350;
                matrix.push();
                if (f.parallelsCord()) {
                    matrix.rotate(-f.getYaw(), 0.0f, 1.0f, 0.0f);
                    matrix.rotate(f.getPitch(), 0.0f, 0.0f, 1.0f);
                }
                matrix.translate(0.0f, -f.getDescent(), 0.0f);
                BoxBuilder bounds = new BoxBuilder();
                class_238 bb = f.getBounds().method_1014(0.01);
                for (class_243 vert : verts = new class_243[]{new class_243(bb.field_1323, bb.field_1322, bb.field_1321), new class_243(bb.field_1320, bb.field_1322, bb.field_1321), new class_243(bb.field_1320, bb.field_1322, bb.field_1321), new class_243(bb.field_1323, bb.field_1322, bb.field_1324), new class_243(bb.field_1323, bb.field_1325, bb.field_1321), new class_243(bb.field_1320, bb.field_1325, bb.field_1321), new class_243(bb.field_1320, bb.field_1325, bb.field_1324), new class_243(bb.field_1323, bb.field_1325, bb.field_1324)}) {
                    bounds.include(matrix.transform(vert));
                }
                matrix.pop();
                return bounds.add(x, y, z).build();
            }));
        }
    }
}

