/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.connection;

import de.lucalabs.fairylights.blocks.FairyLightBlocks;
import de.lucalabs.fairylights.connection.ConnectionType;
import de.lucalabs.fairylights.connection.HangingFeatureConnection;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.feature.FeatureType;
import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.feature.light.LightBehavior;
import de.lucalabs.fairylights.items.HangingLightsConnectionItem;
import de.lucalabs.fairylights.items.LightVariant;
import de.lucalabs.fairylights.items.SimpleLightVariant;
import de.lucalabs.fairylights.sounds.FairyLightSounds;
import de.lucalabs.fairylights.string.StringType;
import de.lucalabs.fairylights.string.StringTypes;
import de.lucalabs.fairylights.util.ItemHelper;
import de.lucalabs.fairylights.util.Tags;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6089;

public final class HangingLightsConnection
extends HangingFeatureConnection<Light<?>> {
    private static final int MAX_LIGHT = 15;
    private static final int LIGHT_UPDATE_WAIT = 400;
    private static final int LIGHT_UPDATE_RATE = 10;
    private final Set<class_2338> litBlocks = new HashSet<class_2338>();
    private final Set<class_2338> oldLitBlocks = new HashSet<class_2338>();
    private StringType string;
    private List<class_1799> pattern;
    private boolean isOn = true;
    private int lightUpdateTime = (int)(Math.random() * 400.0 / 2.0);
    private int lightUpdateIndex;

    public HangingLightsConnection(ConnectionType<? extends HangingLightsConnection> type, class_1937 world, Fastener<?> fastenerOrigin, UUID uuid) {
        super(type, world, fastenerOrigin, uuid);
        this.string = StringTypes.BLACK_STRING;
        this.pattern = new ArrayList<class_1799>();
    }

    public StringType getString() {
        return this.string;
    }

    @Override
    public boolean interact(class_1657 player, class_243 hit, FeatureType featureType, int feature, class_1799 heldStack, class_1268 hand) {
        float pitch;
        class_3414 lightSnd;
        int index;
        class_1799 light;
        if (featureType == FEATURE && heldStack.method_31573(Tags.LIGHTS) && !class_1799.method_7973((class_1799)(light = this.pattern.get(index = feature % this.pattern.size())), (class_1799)heldStack)) {
            class_1799 placed = heldStack.method_7971(1);
            this.pattern.set(index, placed);
            ItemHelper.giveItemToPlayer(player, light);
            this.computeCatenary();
            this.world.method_43128(null, hit.field_1352, hit.field_1351, hit.field_1350, FairyLightSounds.FEATURE_COLOR_CHANGE, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        if (super.interact(player, hit, featureType, feature, heldStack, hand)) {
            return true;
        }
        boolean bl = this.isOn = !this.isOn;
        if (this.isOn) {
            lightSnd = FairyLightSounds.FEATURE_LIGHT_TURNON;
            pitch = 0.6f;
        } else {
            lightSnd = FairyLightSounds.FEATURE_LIGHT_TURNOFF;
            pitch = 0.5f;
        }
        this.world.method_43128(null, hit.field_1352, hit.field_1351, hit.field_1350, lightSnd, class_3419.field_15245, 1.0f, pitch);
        this.computeCatenary();
        return true;
    }

    @Override
    public void onUpdate() {
        boolean on = !this.isDynamic() && this.isOn;
        for (Light light : (Light[])this.features) {
            light.tick(this.world, this.fastener.getConnectionPoint());
        }
        if (on && ((Light[])this.features).length > 0) {
            ++this.lightUpdateTime;
            if (this.lightUpdateTime > 400 && this.lightUpdateTime % 10 == 0) {
                if (this.lightUpdateIndex >= ((Light[])this.features).length) {
                    this.lightUpdateIndex = 0;
                    this.lightUpdateTime = this.world.field_9229.method_43048(200);
                } else {
                    this.setLight(class_2338.method_49638((class_2374)((Light[])this.features)[this.lightUpdateIndex++].getAbsolutePoint(this.fastener)));
                }
            }
        }
    }

    private void updateNeighbors(Fastener<?> fastener) {
        this.world.method_8455(fastener.getPos(), (class_2248)FairyLightBlocks.FASTENER);
    }

    protected Light<?>[] createFeatures(int length) {
        return new Light[length];
    }

    @Override
    protected boolean canReuse(Light<?> feature, int index) {
        return class_1799.method_7973((class_1799)feature.getItem(), (class_1799)this.getPatternStack(index));
    }

    @Override
    protected Light<?> createFeature(int index, class_243 point, float yaw, float pitch) {
        class_1799 lightData = this.getPatternStack(index);
        return this.createLight(index, point, yaw, pitch, lightData, LightVariant.get(lightData).orElse(SimpleLightVariant.FAIRY_LIGHT));
    }

    private class_1799 getPatternStack(int index) {
        return this.pattern.isEmpty() ? class_1799.field_8037 : this.pattern.get(index % this.pattern.size());
    }

    @Override
    protected void updateFeature(Light<?> light) {
        super.updateFeature(light);
        if (!this.isDynamic() && this.isOn) {
            class_2338 pos = class_2338.method_49638((class_2374)light.getAbsolutePoint(this.fastener));
            this.litBlocks.add(pos);
            this.setLight(pos);
        }
    }

    private <T extends LightBehavior> Light<T> createLight(int index, class_243 point, float yaw, float pitch, class_1799 stack, LightVariant<T> variant) {
        return new Light<T>(index, point, yaw, pitch, stack, variant, 0.125f);
    }

    @Override
    protected float getFeatureSpacing() {
        if (this.pattern.isEmpty()) {
            return SimpleLightVariant.FAIRY_LIGHT.getSpacing();
        }
        float spacing = 0.0f;
        for (class_1799 patternLightData : this.pattern) {
            float lightSpacing = LightVariant.get(patternLightData).orElse(SimpleLightVariant.FAIRY_LIGHT).getSpacing();
            if (!(lightSpacing > spacing)) continue;
            spacing = lightSpacing;
        }
        return spacing;
    }

    @Override
    protected void onBeforeUpdateFeatures() {
        this.oldLitBlocks.clear();
        this.oldLitBlocks.addAll(this.litBlocks);
        this.litBlocks.clear();
    }

    @Override
    protected void onAfterUpdateFeatures() {
        boolean on = !this.isDynamic() && this.isOn;
        for (Light light : (Light[])this.features) {
            light.power(on, this.isDynamic() || this.prevCatenary == null);
        }
        this.oldLitBlocks.removeAll(this.litBlocks);
        Iterator<class_2338> oldIter = this.oldLitBlocks.iterator();
        while (oldIter.hasNext()) {
            this.removeLight(oldIter.next());
            oldIter.remove();
        }
    }

    @Override
    public void onRemove() {
        for (class_2338 pos : this.litBlocks) {
            this.removeLight(pos);
        }
    }

    private void removeLight(class_2338 pos) {
        if (this.world.method_8320(pos).method_27852(class_2246.field_31037)) {
            this.world.method_8650(pos, false);
        }
    }

    private void setLight(class_2338 pos) {
        if (this.world.method_8477(pos) && this.world.method_22347(pos) && this.world.method_8314(class_1944.field_9282, pos) < 15) {
            this.world.method_8652(pos, (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(15)), 2);
        }
    }

    @Override
    public class_2487 serialize() {
        class_2487 compound = super.serialize();
        compound.method_10556("isOn", this.isOn);
        class_2499 litBlocks = new class_2499();
        for (class_2338 litBlock : this.litBlocks) {
            litBlocks.add((Object)class_2512.method_10692((class_2338)litBlock));
        }
        compound.method_10566("litBlocks", (class_2520)litBlocks);
        return compound;
    }

    @Override
    public void deserialize(class_2487 compound) {
        super.deserialize(compound);
        this.isOn = compound.method_10577("isOn");
        this.litBlocks.clear();
        class_2499 litBlocks = compound.method_10554("litBlocks", 10);
        for (int i = 0; i < litBlocks.size(); ++i) {
            this.litBlocks.add(class_2512.method_10691((class_2487)litBlocks.method_10602(i)));
        }
    }

    @Override
    public class_2487 serializeLogic() {
        class_2487 compound = super.serializeLogic();
        HangingLightsConnectionItem.setString(compound, this.string);
        class_2499 tagList = new class_2499();
        for (class_1799 light : this.pattern) {
            tagList.add((Object)light.method_7953(new class_2487()));
        }
        compound.method_10566("pattern", (class_2520)tagList);
        return compound;
    }

    @Override
    public void deserializeLogic(class_2487 compound) {
        super.deserializeLogic(compound);
        this.string = HangingLightsConnectionItem.getString(compound);
        class_2499 patternList = compound.method_10554("pattern", 10);
        this.pattern = new ArrayList<class_1799>();
        for (int i = 0; i < patternList.size(); ++i) {
            class_2487 lightCompound = patternList.method_10602(i);
            this.pattern.add(class_1799.method_7915((class_2487)lightCompound));
        }
    }
}

