/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.connection;

import de.lucalabs.fairylights.connection.ConnectionType;
import de.lucalabs.fairylights.connection.HangingFeatureConnection;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.feature.FeatureType;
import de.lucalabs.fairylights.feature.Pennant;
import de.lucalabs.fairylights.items.DyeableItem;
import de.lucalabs.fairylights.sounds.FairyLightSounds;
import de.lucalabs.fairylights.util.ItemHelper;
import de.lucalabs.fairylights.util.OreDictUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3419;

public final class PennantBuntingConnection
extends HangingFeatureConnection<Pennant> {
    private List<class_1799> pattern = new ArrayList<class_1799>();

    public PennantBuntingConnection(ConnectionType<? extends PennantBuntingConnection> type, class_1937 world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    @Override
    public float getRadius() {
        return 0.045f;
    }

    @Override
    public boolean interact(class_1657 player, class_243 hit, FeatureType featureType, int feature, class_1799 heldStack, class_1268 hand) {
        int index;
        class_1799 pennant;
        if (featureType == FEATURE && OreDictUtils.isDye(heldStack) && !class_1799.method_7973((class_1799)(pennant = this.pattern.get(index = feature % this.pattern.size())), (class_1799)heldStack)) {
            class_1799 placed = heldStack.method_7971(1);
            this.pattern.set(index, placed);
            ItemHelper.giveItemToPlayer(player, pennant);
            this.computeCatenary();
            heldStack.method_7934(1);
            this.world.method_43128(null, hit.field_1352, hit.field_1351, hit.field_1350, FairyLightSounds.FEATURE_COLOR_CHANGE, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return super.interact(player, hit, featureType, feature, heldStack, hand);
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        for (Pennant light : (Pennant[])this.features) {
            light.tick(this.world);
        }
    }

    protected Pennant[] createFeatures(int length) {
        return new Pennant[length];
    }

    @Override
    protected Pennant createFeature(int index, class_243 point, float yaw, float pitch) {
        class_1799 data = this.pattern.isEmpty() ? class_1799.field_8037 : this.pattern.get(index % this.pattern.size());
        return new Pennant(index, point, yaw, pitch, DyeableItem.getColor(data), data.method_7909());
    }

    @Override
    protected float getFeatureSpacing() {
        return 0.6875f;
    }

    @Override
    public class_2487 serializeLogic() {
        class_2487 compound = super.serializeLogic();
        class_2499 patternList = new class_2499();
        for (class_1799 entry : this.pattern) {
            patternList.add((Object)entry.method_7953(new class_2487()));
        }
        compound.method_10566("pattern", (class_2520)patternList);
        return compound;
    }

    @Override
    public void deserializeLogic(class_2487 compound) {
        super.deserializeLogic(compound);
        this.pattern = new ArrayList<class_1799>();
        class_2499 patternList = compound.method_10554("pattern", 10);
        for (int i = 0; i < patternList.size(); ++i) {
            this.pattern.add(class_1799.method_7915((class_2487)patternList.method_10602(i)));
        }
    }
}

