/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.fastener;

import de.lucalabs.fairylights.fastener.accessor.BlockFastenerAccessor;
import de.lucalabs.fairylights.fastener.accessor.FastenerAccessor;
import de.lucalabs.fairylights.fastener.accessor.FenceFastenerAccessor;
import de.lucalabs.fairylights.fastener.accessor.PlayerFastenerAccessor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public enum FastenerType {
    BLOCK(BlockFastenerAccessor::new),
    FENCE(FenceFastenerAccessor::new),
    PLAYER(PlayerFastenerAccessor::new);

    private static final Map<String, FastenerType> NAME_TO_TYPE;
    private final Supplier<? extends FastenerAccessor> supplier;
    private final String name;

    private FastenerType(Supplier<? extends FastenerAccessor> supplier) {
        this.supplier = supplier;
        this.name = this.name().toLowerCase(Locale.ENGLISH);
    }

    public final FastenerAccessor createAccessor() {
        return this.supplier.get();
    }

    public static class_2487 serialize(FastenerAccessor accessor) {
        class_2487 compound = new class_2487();
        compound.method_10582("type", accessor.getType().name);
        compound.method_10566("data", (class_2520)accessor.serialize());
        return compound;
    }

    public static FastenerAccessor deserialize(class_2487 compound) {
        FastenerAccessor accessor = NAME_TO_TYPE.get(compound.method_10558("type")).createAccessor();
        accessor.deserialize(compound.method_10562("data"));
        return accessor;
    }

    static {
        NAME_TO_TYPE = new HashMap<String, FastenerType>();
        for (FastenerType type : FastenerType.values()) {
            NAME_TO_TYPE.put(type.name, type);
        }
    }
}

