/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.feature;

import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.feature.Feature;
import de.lucalabs.fairylights.util.MathHelper;
import de.lucalabs.fairylights.util.matrix.MatrixStack;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;

public abstract class HangingFeature
implements Feature {
    protected final int index;
    protected class_243 point;
    protected class_243 prevPoint;
    private class_243 targetPoint;
    protected float yaw;
    protected float pitch;
    protected float roll;
    protected float prevYaw;
    protected float prevPitch;
    protected float prevRoll;
    protected float targetYaw;
    protected float targetPitch;
    protected final float descent;

    public HangingFeature(int index, class_243 point, float yaw, float pitch, float roll, float descent) {
        this.index = index;
        this.prevPoint = this.targetPoint = point;
        this.point = this.targetPoint;
        this.yaw = this.targetYaw = yaw;
        this.prevYaw = this.targetYaw;
        this.pitch = this.targetPitch = pitch;
        this.prevPitch = this.targetPitch;
        this.prevRoll = this.roll = roll;
        this.descent = descent;
    }

    public void set(class_243 point, float yaw, float pitch) {
        this.targetPoint = point;
        this.targetYaw = yaw;
        this.targetPitch = pitch;
    }

    @Override
    public final int getId() {
        return this.index;
    }

    public final class_243 getPoint() {
        return this.targetPoint;
    }

    public final class_243 getPoint(float delta) {
        return this.point.method_1020(this.prevPoint).method_1021((double)delta).method_1019(this.prevPoint);
    }

    public final float getYaw() {
        return this.yaw;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final float getRoll() {
        return this.roll;
    }

    public final float getYaw(float t) {
        return MathHelper.lerpAngle(this.prevYaw, this.yaw, t);
    }

    public final float getPitch(float t) {
        return MathHelper.lerpAngle(this.prevPitch, this.pitch, t);
    }

    public final float getRoll(float t) {
        return MathHelper.lerpAngle(this.prevRoll, this.roll, t);
    }

    public float getDescent() {
        return this.descent;
    }

    public final class_243 getAbsolutePoint(Fastener<?> fastener) {
        return this.getAbsolutePoint(fastener.getConnectionPoint());
    }

    public final class_243 getAbsolutePoint(class_243 origin) {
        return this.point.method_1019(origin);
    }

    public class_243 getTransformedPoint(class_243 origin, class_243 point) {
        MatrixStack matrix = new MatrixStack();
        matrix.rotate(-this.getYaw(), 0.0f, 1.0f, 0.0f);
        if (this.parallelsCord()) {
            matrix.rotate(this.getPitch(), 0.0f, 0.0f, 1.0f);
        }
        matrix.rotate(this.getRoll(), 1.0f, 0.0f, 0.0f);
        matrix.translate(0.0f, -this.getDescent(), 0.0f);
        return this.point.method_1019(matrix.transform(point)).method_1019(origin);
    }

    public void tick(class_1937 world) {
        this.prevPoint = this.point;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.prevRoll = this.roll;
        this.point = this.targetPoint;
        this.yaw = this.targetYaw;
        this.pitch = this.targetPitch;
    }

    public abstract class_238 getBounds();

    public abstract boolean parallelsCord();
}

