/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.feature.light;

import de.lucalabs.fairylights.feature.light.BrightnessLightBehavior;
import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.feature.light.TwinkleLogic;
import de.lucalabs.fairylights.util.CubicBezier;
import de.lucalabs.fairylights.util.MathHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;

public class TwinkleBehavior
implements BrightnessLightBehavior {
    private static final CubicBezier EASE_IN_OUT = new CubicBezier(0.4f, 0.0f, 0.6f, 1.0f);
    private final TwinkleLogic logic;
    private boolean powered = true;

    public TwinkleBehavior(float chance, int duration) {
        this.logic = new TwinkleLogic(chance, duration);
    }

    public static boolean exists(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10577("twinkle");
    }

    @Override
    public float getBrightness(float delta) {
        if (this.powered) {
            float x = this.logic.get(delta);
            return x < 0.25f ? 1.0f - EASE_IN_OUT.eval(x / 0.25f) : EASE_IN_OUT.eval(MathHelper.transform(x, 0.25f, 1.0f, 0.0f, 1.0f));
        }
        return 0.0f;
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
    }

    @Override
    public void tick(class_1937 world, class_243 origin, Light<?> light) {
        this.logic.tick(world.field_9229, this.powered);
    }
}

