/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.integrations.emi;

import de.lucalabs.fairylights.items.DyeableItem;
import de.lucalabs.fairylights.items.FairyLightItems;
import de.lucalabs.fairylights.items.crafting.GenericRecipe;
import de.lucalabs.fairylights.util.Tags;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.LinkedList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class FairyLightEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        class_638 world = class_310.method_1551().field_1687;
        class_1863 recipeManager = world.method_8433();
        this.simplifyFastenerRecipes(registry);
        recipeManager.method_8126().stream().filter(GenericRecipe.class::isInstance).map(GenericRecipe.class::cast).flatMap(r -> {
            class_1799 output = r.getOutput();
            LinkedList<EmiCraftingRecipe> recipes = new LinkedList<EmiCraftingRecipe>();
            if (output.method_31573(Tags.DYEABLE)) {
                for (class_1767 color : class_1767.values()) {
                    class_1799 coloredOutput = DyeableItem.setColor(output, color);
                    recipes.add(new EmiCraftingRecipe(r.method_8117().stream().map(i -> {
                        if (i.method_8105().length > 0 && Arrays.stream(i.method_8105()).allMatch(it -> it.method_31573(Tags.DYES))) {
                            return class_1856.method_8091((class_1935[])new class_1935[]{class_1769.method_7803((class_1767)color)});
                        }
                        return i;
                    }).map(EmiIngredient::of).toList(), EmiStack.of((class_1799)coloredOutput), r.method_8114().method_45136("/" + r.method_8114().method_12832() + "_" + color.method_7792()), false));
                }
            } else {
                recipes.add(new EmiCraftingRecipe(r.method_8117().stream().map(EmiIngredient::of).toList(), EmiStack.of((class_1799)output), r.method_8114(), false));
            }
            return recipes.stream();
        }).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private void simplifyFastenerRecipes(EmiRegistry registry) {
        EmiStack hl = EmiStack.of((class_1935)FairyLightItems.HANGING_LIGHTS).comparison(Comparison.of((i1, i2) -> i1.hasNbt() || i2.hasNbt()));
        registry.removeEmiStacks(hl);
        EmiStack pb = EmiStack.of((class_1935)FairyLightItems.PENNANT_BUNTING).comparison(Comparison.of((i1, i2) -> i1.hasNbt() || i2.hasNbt()));
        registry.removeEmiStacks(pb);
        EmiStack newHl = EmiStack.of((class_1935)FairyLightItems.HANGING_LIGHTS);
        registry.addEmiStackAfter(newHl, hl);
        EmiStack newPb = EmiStack.of((class_1935)FairyLightItems.PENNANT_BUNTING);
        registry.addEmiStackAfter(newPb, pb);
        String[] ignoredRecipes = new String[]{"crafting_special_pennant_bunting_augmentation", "pennant_bunting_augmentation", "crafting_special_hanging_lights_augmentation", "hanging_lights_augmentation"};
        registry.removeRecipes(r -> Arrays.stream(ignoredRecipes).anyMatch(i -> r.getId() != null && i.equals(r.getId().method_12832())));
    }
}

