/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public final class DyeableItem {
    private DyeableItem() {
    }

    public static class_2561 getColorName(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        class_1767 closest = class_1767.field_7952;
        int closestDist = Integer.MAX_VALUE;
        for (class_1767 dye : class_1767.values()) {
            int dyeColor = DyeableItem.getColor(dye);
            if (dyeColor == color) {
                closest = dye;
                closestDist = 0;
                break;
            }
            int dr = dyeColor >> 16 & 0xFF;
            int dg = dyeColor >> 8 & 0xFF;
            int db = dyeColor & 0xFF;
            int dist = (dr - r) * (dr - r) + (dg - g) * (dg - g) + (db - b) * (db - b);
            if (dist >= closestDist) continue;
            closest = dye;
            closestDist = dist;
        }
        class_5250 colorName = class_2561.method_43471((String)("color.fairylights." + closest.method_7792()));
        return closestDist == 0 ? colorName : class_2561.method_43469((String)"format.fairylights.dyed_colored", (Object[])new Object[]{colorName});
    }

    public static class_2561 getDisplayName(class_1799 stack, class_2561 name) {
        return class_2561.method_43469((String)"format.fairylights.colored", (Object[])new Object[]{DyeableItem.getColorName(DyeableItem.getColor(stack)), name});
    }

    public static int getColor(class_1767 color) {
        if (color == class_1767.field_7963) {
            return 0x323232;
        }
        if (color == class_1767.field_7944) {
            return 0x606060;
        }
        float[] colors = color.method_7787();
        return class_3532.method_15375((float)(colors[0] * 255.0f)) << 16 | class_3532.method_15375((float)(colors[1] * 255.0f)) << 8 | class_3532.method_15375((float)(colors[2] * 255.0f));
    }

    public static Optional<class_1767> getDyeColor(class_1799 stack) {
        int color = DyeableItem.getColor(stack);
        return Arrays.stream(class_1767.values()).filter(dye -> DyeableItem.getColor(dye) == color).findFirst();
    }

    public static class_1799 setColor(class_1799 stack, class_1767 dye) {
        return DyeableItem.setColor(stack, DyeableItem.getColor(dye));
    }

    public static class_1799 setColor(class_1799 stack, int color) {
        DyeableItem.setColor(stack.method_7948(), color);
        return stack;
    }

    public static class_2487 setColor(class_2487 tag, class_1767 dye) {
        return DyeableItem.setColor(tag, DyeableItem.getColor(dye));
    }

    public static class_2487 setColor(class_2487 tag, int color) {
        tag.method_10569("color", color);
        return tag;
    }

    public static int getColor(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null ? DyeableItem.getColor(tag) : 0xFFFFFF;
    }

    public static int getColor(class_2487 tag) {
        return tag.method_10573("color", 3) ? tag.method_10550("color") : 0xFFFFFF;
    }
}

