/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items;

import de.lucalabs.fairylights.feature.light.BrightnessLightBehavior;
import de.lucalabs.fairylights.feature.light.ColorLightBehavior;
import de.lucalabs.fairylights.feature.light.CompositeBehavior;
import de.lucalabs.fairylights.feature.light.DefaultBrightnessBehavior;
import de.lucalabs.fairylights.feature.light.FixedColorBehavior;
import de.lucalabs.fairylights.feature.light.IncandescentBehavior;
import de.lucalabs.fairylights.feature.light.LightBehavior;
import de.lucalabs.fairylights.feature.light.StandardLightBehavior;
import de.lucalabs.fairylights.feature.light.TorchLightBehavior;
import de.lucalabs.fairylights.feature.light.TwinkleBehavior;
import de.lucalabs.fairylights.items.LightVariant;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_238;

public class SimpleLightVariant<T extends LightBehavior>
extends LightVariant<T> {
    public static final LightVariant<StandardLightBehavior> FAIRY_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new class_238(-0.138, -0.138, -0.138, 0.138, 0.138, 0.138), 0.044, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<BrightnessLightBehavior> OIL_LANTERN = new SimpleLightVariant<BrightnessLightBehavior>(false, 1.5f, new class_238(-0.219, -0.656, -0.188, 0.219, 0.091, 0.188), 0.0, stack -> new TorchLightBehavior(0.13));
    public static final LightVariant<BrightnessLightBehavior> INCANDESCENT_LIGHT = new SimpleLightVariant<BrightnessLightBehavior>(true, 1.0f, new class_238(-0.166, -0.291, -0.166, 0.166, 0.062, 0.166), 0.103, stack -> new IncandescentBehavior(), true);
    private final boolean parallelsCord;
    private final float spacing;
    private final class_238 bounds;
    private final double floorOffset;
    private final Function<class_1799, T> behaviorFactory;
    private final boolean orientable;

    SimpleLightVariant(boolean parallelsCord, float spacing, class_238 bounds, double floorOffset, Function<class_1799, T> behaviorFactory) {
        this(parallelsCord, spacing, bounds, floorOffset, behaviorFactory, false);
    }

    SimpleLightVariant(boolean parallelsCord, float spacing, class_238 bounds, double floorOffset, Function<class_1799, T> behaviorFactory, boolean orientable) {
        this.parallelsCord = parallelsCord;
        this.spacing = spacing;
        this.bounds = bounds;
        this.floorOffset = floorOffset;
        this.behaviorFactory = behaviorFactory;
        this.orientable = orientable;
    }

    private static StandardLightBehavior standardBehavior(class_1799 stack) {
        BrightnessLightBehavior brightness = TwinkleBehavior.exists(stack) ? new TwinkleBehavior(0.05f, 40) : new DefaultBrightnessBehavior();
        ColorLightBehavior color = FixedColorBehavior.create(stack);
        return new CompositeBehavior(brightness, color);
    }

    @Override
    public boolean parallelsCord() {
        return this.parallelsCord;
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public class_238 getBounds() {
        return this.bounds;
    }

    @Override
    public double getFloorOffset() {
        return this.floorOffset;
    }

    @Override
    public T createBehavior(class_1799 stack) {
        return (T)((LightBehavior)this.behaviorFactory.apply(stack));
    }

    @Override
    public boolean isOrientable() {
        return this.orientable;
    }
}

