/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items.crafting;

import com.google.common.collect.ImmutableList;
import de.lucalabs.fairylights.FairyLights;
import de.lucalabs.fairylights.items.DyeableItem;
import de.lucalabs.fairylights.items.FairyLightItems;
import de.lucalabs.fairylights.items.HangingLightsConnectionItem;
import de.lucalabs.fairylights.items.crafting.CopyColorRecipe;
import de.lucalabs.fairylights.items.crafting.GenericRecipe;
import de.lucalabs.fairylights.items.crafting.GenericRecipeBuilder;
import de.lucalabs.fairylights.items.crafting.RegularIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.BasicAuxiliaryIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.BasicRegularIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.InertBasicAuxiliaryIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.LazyTagIngredient;
import de.lucalabs.fairylights.string.StringTypes;
import de.lucalabs.fairylights.util.Blender;
import de.lucalabs.fairylights.util.OreDictUtils;
import de.lucalabs.fairylights.util.Tags;
import de.lucalabs.fairylights.util.Utils;
import de.lucalabs.fairylights.util.styled.StyledString;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_7923;

public final class FairyLightCraftingRecipes {
    public static final class_1865<GenericRecipe> HANGING_LIGHTS = FairyLightCraftingRecipes.register("crafting_special_hanging_lights", () -> new class_1866(FairyLightCraftingRecipes::createHangingLights));
    public static final class_1865<GenericRecipe> HANGING_LIGHTS_AUGMENTATION = FairyLightCraftingRecipes.register("crafting_special_hanging_lights_augmentation", () -> new class_1866(FairyLightCraftingRecipes::createHangingLightsAugmentation));
    public static final class_1865<GenericRecipe> PENNANT_BUNTING = FairyLightCraftingRecipes.register("crafting_special_pennant_bunting", () -> new class_1866(FairyLightCraftingRecipes::createPennantBunting));
    public static final class_1865<GenericRecipe> PENNANT_BUNTING_AUGMENTATION = FairyLightCraftingRecipes.register("crafting_special_pennant_bunting_augmentation", () -> new class_1866(FairyLightCraftingRecipes::createPennantBuntingAugmentation));
    public static final class_1865<GenericRecipe> TRIANGLE_PENNANT = FairyLightCraftingRecipes.register("crafting_special_triangle_pennant", () -> new class_1866(FairyLightCraftingRecipes::createTrianglePennant));
    public static final class_1865<GenericRecipe> SQUARE_PENNANT = FairyLightCraftingRecipes.register("crafting_special_square_pennant", () -> new class_1866(FairyLightCraftingRecipes::createSquarePennant));
    public static final class_1865<GenericRecipe> FAIRY_LIGHT = FairyLightCraftingRecipes.register("crafting_special_fairy_light", () -> new class_1866(FairyLightCraftingRecipes::createFairyLight));
    public static final class_1865<GenericRecipe> LIGHT_TWINKLE = FairyLightCraftingRecipes.register("crafting_special_light_twinkle", () -> new class_1866(FairyLightCraftingRecipes::createLightTwinkle));
    public static final class_1865<GenericRecipe> COLOR_CHANGING_LIGHT = FairyLightCraftingRecipes.register("crafting_special_color_changing_light", () -> new class_1866(FairyLightCraftingRecipes::createColorChangingLight));
    public static final class_1865<GenericRecipe> EDIT_COLOR = FairyLightCraftingRecipes.register("crafting_special_edit_color", () -> new class_1866(FairyLightCraftingRecipes::createDyeColor));
    public static final class_1865<class_1852> COPY_COLOR = FairyLightCraftingRecipes.register("crafting_special_copy_color", () -> new class_1866(CopyColorRecipe::new));
    public static final RegularIngredient DYE_SUBTYPE_INGREDIENT = new BasicRegularIngredient(LazyTagIngredient.of(Tags.DYES)){

        @Override
        public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
            return DyeableItem.getDyeColor(output).map(dye -> ImmutableList.of(OreDictUtils.getDyes(dye))).orElse(ImmutableList.of());
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public void matched(class_1799 ingredient, class_2487 nbt) {
            DyeableItem.setColor(nbt, OreDictUtils.getDyeColor(ingredient));
        }
    };

    private FairyLightCraftingRecipes() {
    }

    private static GenericRecipe createDyeColor(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> EDIT_COLOR).withShape("I").withIngredient('I', Tags.DYEABLE).withOutput('I').withAuxiliaryIngredient(new BasicAuxiliaryIngredient<Blender>((class_1856)LazyTagIngredient.of(Tags.DYES), true, 8){

            @Override
            public Blender accumulator() {
                return new Blender();
            }

            @Override
            public void consume(Blender data, class_1799 ingredient) {
                data.add(DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient)));
            }

            @Override
            public boolean finish(Blender data, class_2487 nbt) {
                DyeableItem.setColor(nbt, data.blend());
                return false;
            }
        }).build();
    }

    private static GenericRecipe createLightTwinkle(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> LIGHT_TWINKLE).withShape("L").withIngredient('L', Tags.TWINKLING_LIGHTS).withOutput('L').withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8601}), true, 1){

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                return FairyLightCraftingRecipes.useInputsForTagBool(output, "twinkle", true) ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(class_2487 nbt) {
                nbt.method_10556("twinkle", true);
            }

            @Override
            public void absent(class_2487 nbt) {
                nbt.method_10556("twinkle", false);
            }

            @Override
            public void addTooltip(List<class_2561> tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.twinkling_lights.glowstone"));
            }
        }).build();
    }

    private static GenericRecipe createColorChangingLight(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> COLOR_CHANGING_LIGHT).withShape("IG").withIngredient('I', Tags.DYEABLE_LIGHTS).withOutput('I').withIngredient('G', class_1802.field_8397).withAuxiliaryIngredient(new BasicAuxiliaryIngredient<class_2499>((class_1856)LazyTagIngredient.of(Tags.DYES), true, 8){

            @Override
            public class_2499 accumulator() {
                return new class_2499();
            }

            @Override
            public void consume(class_2499 data, class_1799 ingredient) {
                data.add((Object)class_2497.method_23247((int)DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient))));
            }

            @Override
            public boolean finish(class_2499 data, class_2487 nbt) {
                if (!data.isEmpty()) {
                    if (nbt.method_10573("color", 3)) {
                        data.method_10531(0, (class_2520)class_2497.method_23247((int)nbt.method_10550("color")));
                        nbt.method_10551("color");
                    }
                    nbt.method_10566("colors", (class_2520)data);
                }
                return false;
            }
        }).build();
    }

    private static GenericRecipe createHangingLights(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> HANGING_LIGHTS, FairyLightItems.HANGING_LIGHTS).withShape("I-I").withIngredient('I', class_1802.field_8620).withIngredient('-', class_1802.field_8276).withAuxiliaryIngredient(new LightIngredient(true)).withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of(Tags.DYES_WHITE), false, 1){

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                class_2487 tag = output.method_7969();
                return tag != null && HangingLightsConnectionItem.getString(tag) == StringTypes.WHITE_STRING ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(class_2487 nbt) {
                HangingLightsConnectionItem.setString(nbt, StringTypes.WHITE_STRING);
            }

            @Override
            public void absent(class_2487 nbt) {
                HangingLightsConnectionItem.setString(nbt, StringTypes.BLACK_STRING);
            }

            @Override
            public void addTooltip(List<class_2561> tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.string"));
            }
        }).build();
    }

    private static boolean useInputsForTagBool(class_1799 output, String key, boolean value) {
        class_2487 compound = output.method_7969();
        return compound != null && compound.method_10577(key) == value;
    }

    private static GenericRecipe createHangingLightsAugmentation(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> HANGING_LIGHTS_AUGMENTATION, FairyLightItems.HANGING_LIGHTS).withShape("F").withIngredient('F', new BasicRegularIngredient(class_1856.method_8091((class_1935[])new class_1935[]{FairyLightItems.HANGING_LIGHTS})){

            @Override
            public ImmutableList<class_1799> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.method_8105()).map(class_1799::method_7972).flatMap(stack -> {
                    stack.method_7980(new class_2487());
                    return FairyLightCraftingRecipes.makeHangingLightsExamples(stack).stream();
                }).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                class_1799 stack = output.method_7972();
                class_2487 compound = stack.method_7969();
                if (compound == null) {
                    return ImmutableList.of();
                }
                stack.method_7939(1);
                return ImmutableList.of((Object)ImmutableList.of((Object)stack));
            }

            @Override
            public void matched(class_1799 ingredient, class_2487 nbt) {
                class_2487 compound = ingredient.method_7969();
                if (compound != null) {
                    nbt.method_10543(compound);
                }
            }
        }).withAuxiliaryIngredient(new LightIngredient(true){

            @Override
            public ImmutableList<class_1799> getInputs() {
                return ImmutableList.of();
            }

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                return ImmutableList.of();
            }
        }).build();
    }

    private static ImmutableList<class_1799> makeHangingLightsExamples(class_1799 stack) {
        return ImmutableList.of((Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7955, class_1767.field_7958, class_1767.field_7955, class_1767.field_7952), (Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7955, class_1767.field_7951, class_1767.field_7955, class_1767.field_7951), (Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7967, class_1767.field_7954, class_1767.field_7955, class_1767.field_7942), (Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7967, class_1767.field_7945, class_1767.field_7967, class_1767.field_7942), (Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7955, class_1767.field_7947, class_1767.field_7955, class_1767.field_7945));
    }

    public static class_1799 makeHangingLights(class_1799 base, class_1767 ... colors) {
        class_1799 stack = base.method_7972();
        class_2487 compound = stack.method_7969();
        class_2499 lights = new class_2499();
        for (class_1767 color : colors) {
            lights.add((Object)DyeableItem.setColor(new class_1799((class_1935)FairyLightItems.FAIRY_LIGHT), color).method_7953(new class_2487()));
        }
        if (compound == null) {
            compound = new class_2487();
            stack.method_7980(compound);
        }
        compound.method_10566("pattern", (class_2520)lights);
        HangingLightsConnectionItem.setString(compound, StringTypes.BLACK_STRING);
        return stack;
    }

    private static GenericRecipe createPennantBunting(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> PENNANT_BUNTING, FairyLightItems.PENNANT_BUNTING).withShape("I-I").withIngredient('I', class_1802.field_8620).withIngredient('-', class_1802.field_8276).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static GenericRecipe createPennantBuntingAugmentation(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> PENNANT_BUNTING_AUGMENTATION, FairyLightItems.PENNANT_BUNTING).withShape("B").withIngredient('B', new BasicRegularIngredient(class_1856.method_8091((class_1935[])new class_1935[]{FairyLightItems.PENNANT_BUNTING})){

            @Override
            public ImmutableList<class_1799> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.method_8105()).map(class_1799::method_7972).flatMap(stack -> {
                    stack.method_7980(new class_2487());
                    return FairyLightCraftingRecipes.makePennantExamples(stack).stream();
                }).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                class_2487 compound = output.method_7969();
                if (compound == null) {
                    return ImmutableList.of();
                }
                return ImmutableList.of(FairyLightCraftingRecipes.makePennantExamples(output));
            }

            @Override
            public void matched(class_1799 ingredient, class_2487 nbt) {
                class_2487 compound = ingredient.method_7969();
                if (compound != null) {
                    nbt.method_10543(compound);
                }
            }
        }).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static ImmutableList<class_1799> makePennantExamples(class_1799 stack) {
        return ImmutableList.of((Object)FairyLightCraftingRecipes.makePennant(stack, class_1767.field_7966, class_1767.field_7947, class_1767.field_7964), (Object)FairyLightCraftingRecipes.makePennant(stack, class_1767.field_7954, class_1767.field_7951), (Object)FairyLightCraftingRecipes.makePennant(stack, class_1767.field_7946, class_1767.field_7952), (Object)FairyLightCraftingRecipes.makePennant(stack, class_1767.field_7961, class_1767.field_7947));
    }

    public static class_1799 makePennant(class_1799 base, class_1767 ... colors) {
        class_1799 stack = base.method_7972();
        class_2487 compound = stack.method_7969();
        class_2499 pennants = new class_2499();
        for (class_1767 color : colors) {
            class_1799 pennant = new class_1799((class_1935)FairyLightItems.TRIANGLE_PENNANT);
            DyeableItem.setColor(pennant, color);
            pennants.add((Object)pennant.method_7953(new class_2487()));
        }
        if (compound == null) {
            compound = new class_2487();
            stack.method_7980(compound);
        }
        compound.method_10566("pattern", (class_2520)pennants);
        compound.method_10566("text", (class_2520)StyledString.serialize(new StyledString()));
        return stack;
    }

    private static GenericRecipe createPennant(class_2960 name, Supplier<class_1865<GenericRecipe>> serializer, class_1792 item, String pattern) {
        return new GenericRecipeBuilder(name, serializer, item).withShape("- -", "PDP", pattern).withIngredient('P', class_1802.field_8407).withIngredient('-', class_1802.field_8276).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createTrianglePennant(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createPennant(name, () -> TRIANGLE_PENNANT, FairyLightItems.TRIANGLE_PENNANT, " P ");
    }

    private static GenericRecipe createSquarePennant(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createPennant(name, () -> SQUARE_PENNANT, FairyLightItems.SQUARE_PENNANT, "PPP");
    }

    private static GenericRecipe createFairyLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> FAIRY_LIGHT, () -> FairyLightItems.FAIRY_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', class_1802.field_8141));
    }

    private static GenericRecipe createLight(class_2960 name, Supplier<? extends class_1865<GenericRecipe>> serializer, Supplier<? extends class_1792> variant, UnaryOperator<GenericRecipeBuilder> recipe) {
        return ((GenericRecipeBuilder)recipe.apply(new GenericRecipeBuilder(name, serializer))).withIngredient('I', class_1802.field_8620).withIngredient('D', DYE_SUBTYPE_INGREDIENT).withOutput(variant.get(), 4).build();
    }

    private static <T extends class_1865<?>> T register(String name, Supplier<T> supplier) {
        class_2960 identifier = class_2960.method_43902((String)"fairylights", (String)name);
        return (T)((class_1865)class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)identifier, (Object)((class_1865)supplier.get())));
    }

    public static void initialize() {
        FairyLights.LOGGER.info("Registering items");
    }

    private static class LightIngredient
    extends BasicAuxiliaryIngredient<class_2499> {
        private LightIngredient(boolean isRequired) {
            super(LazyTagIngredient.of(Tags.LIGHTS), isRequired, 8);
        }

        @Override
        public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
            class_2487 compound = output.method_7969();
            if (compound == null) {
                return ImmutableList.of();
            }
            class_2499 pattern = compound.method_10554("pattern", 10);
            if (pattern.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder lights = ImmutableList.builder();
            for (int i = 0; i < pattern.size(); ++i) {
                lights.add((Object)ImmutableList.of((Object)class_1799.method_7915((class_2487)pattern.method_10602(i))));
            }
            return lights.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public class_2499 accumulator() {
            return new class_2499();
        }

        @Override
        public void consume(class_2499 patternList, class_1799 ingredient) {
            patternList.add((Object)ingredient.method_7953(new class_2487()));
        }

        @Override
        public boolean finish(class_2499 pattern, class_2487 nbt) {
            if (!pattern.isEmpty()) {
                nbt.method_10566("pattern", (class_2520)pattern);
            }
            return false;
        }

        @Override
        public void addTooltip(List<class_2561> tooltip) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.light"));
        }
    }

    private static class PennantIngredient
    extends BasicAuxiliaryIngredient<class_2499> {
        private PennantIngredient() {
            super(LazyTagIngredient.of(Tags.PENNANTS), true, 8);
        }

        @Override
        public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
            class_2487 compound = output.method_7969();
            if (compound == null) {
                return ImmutableList.of();
            }
            class_2499 pattern = compound.method_10554("pattern", 10);
            if (pattern.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder pennants = ImmutableList.builder();
            for (int i = 0; i < pattern.size(); ++i) {
                pennants.add((Object)ImmutableList.of((Object)class_1799.method_7915((class_2487)pattern.method_10602(i))));
            }
            return pennants.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public class_2499 accumulator() {
            return new class_2499();
        }

        @Override
        public void consume(class_2499 patternList, class_1799 ingredient) {
            patternList.add((Object)ingredient.method_7953(new class_2487()));
        }

        @Override
        public boolean finish(class_2499 pattern, class_2487 nbt) {
            if (!pattern.isEmpty()) {
                nbt.method_10566("pattern", (class_2520)pattern);
                nbt.method_10566("text", (class_2520)StyledString.serialize(new StyledString()));
            }
            return false;
        }

        @Override
        public void addTooltip(List<class_2561> tooltip) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.pennantBunting.pennant"));
        }
    }
}

