/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items.crafting;

import com.google.common.base.Strings;
import de.lucalabs.fairylights.items.crafting.GenericRecipe;
import de.lucalabs.fairylights.items.crafting.RegularIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.AuxiliaryIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.BasicRegularIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.InertBasicAuxiliaryIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.LazyTagIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public final class GenericRecipeBuilder {
    private static final char EMPTY_SPACE = ' ';
    private class_1799 output;
    private char outputChar = '\u0000';
    private char[] shape = new char[0];
    private int width;
    private int height;
    private final class_2960 name;
    private final Supplier<? extends class_1865<GenericRecipe>> serializer;
    private final Map<Character, RegularIngredient> ingredients = new HashMap<Character, RegularIngredient>();
    private final List<AuxiliaryIngredient<?>> auxiliaryIngredients = new ArrayList();

    public GenericRecipeBuilder(class_2960 name, Supplier<? extends class_1865<GenericRecipe>> serializer) {
        this(name, serializer, class_1799.field_8037);
    }

    public GenericRecipeBuilder(class_2960 name, Supplier<? extends class_1865<GenericRecipe>> serializer, class_1792 item) {
        this(name, serializer, new class_1799((class_1935)item));
    }

    public GenericRecipeBuilder(class_2960 name, Supplier<? extends class_1865<GenericRecipe>> serializer, class_2248 block) {
        this(name, serializer, new class_1799((class_1935)block));
    }

    public GenericRecipeBuilder(class_2960 name, Supplier<? extends class_1865<GenericRecipe>> serializer, class_1799 output) {
        this.name = name;
        this.serializer = serializer;
        this.output = Objects.requireNonNull(output, "output");
    }

    public GenericRecipeBuilder withShape(String ... shape) {
        Objects.requireNonNull(shape, "shape");
        this.width = 0;
        this.height = 0;
        for (String row : shape) {
            if (row != null && row.length() > this.width) {
                this.width = row.length();
            }
            ++this.height;
        }
        StringBuilder bob = new StringBuilder();
        for (String row : shape) {
            bob.append(Strings.nullToEmpty((String)row));
            int trail = this.width - (row == null ? 0 : row.length());
            while (trail-- > 0) {
                bob.append(' ');
            }
        }
        this.shape = bob.toString().toCharArray();
        return this;
    }

    public GenericRecipeBuilder withOutput(class_1792 item) {
        return this.withOutput(Objects.requireNonNull(item, "item"), 1);
    }

    public GenericRecipeBuilder withOutput(class_1792 item, int size) {
        return this.withOutput(new class_1799((class_1935)Objects.requireNonNull(item, "item"), size));
    }

    public GenericRecipeBuilder withOutput(class_2248 block) {
        return this.withOutput(Objects.requireNonNull(block, "block"), 1);
    }

    public GenericRecipeBuilder withOutput(class_2248 block, int size) {
        return this.withOutput(new class_1799((class_1935)Objects.requireNonNull(block, "block"), size));
    }

    public GenericRecipeBuilder withOutput(class_1799 output) {
        this.output = Objects.requireNonNull(output, "output");
        return this;
    }

    public GenericRecipeBuilder withOutput(char key) {
        this.outputChar = key;
        return this;
    }

    public GenericRecipeBuilder withIngredient(char key, class_1792 item) {
        return this.withIngredient(key, new class_1799((class_1935)Objects.requireNonNull(item, "item"), 1));
    }

    public GenericRecipeBuilder withIngredient(char key, class_2248 block) {
        return this.withIngredient(key, new class_1799((class_1935)Objects.requireNonNull(block, "block"), 1));
    }

    public GenericRecipeBuilder withIngredient(char key, class_1799 stack) {
        return this.withIngredient(key, class_1856.method_8101((class_1799[])new class_1799[]{Objects.requireNonNull(stack, "stack")}));
    }

    public GenericRecipeBuilder withIngredient(char key, class_1856 ingredient) {
        return this.withIngredient(key, new BasicRegularIngredient(ingredient));
    }

    public GenericRecipeBuilder withIngredient(char key, class_6862<class_1792> tag) {
        return this.withIngredient(key, new BasicRegularIngredient(LazyTagIngredient.of(tag)));
    }

    public GenericRecipeBuilder withIngredient(char key, RegularIngredient ingredient) {
        this.ingredients.put(Character.valueOf(key), Objects.requireNonNull(ingredient, "ingredient"));
        return this;
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_1792 item) {
        return this.withAuxiliaryIngredient(new class_1799((class_1935)Objects.requireNonNull(item, "item")));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_1792 item, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new class_1799((class_1935)Objects.requireNonNull(item, "item")), isRequired, limit);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_2248 block) {
        return this.withAuxiliaryIngredient(new class_1799((class_1935)Objects.requireNonNull(block, "block")));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_2248 block, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new class_1799((class_1935)Objects.requireNonNull(block, "block")), isRequired, limit);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_1799 stack) {
        return this.withAuxiliaryIngredient(Objects.requireNonNull(stack, "stack"), false, 1);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_1799 stack, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(class_1856.method_8101((class_1799[])new class_1799[]{Objects.requireNonNull(stack, "stack")}), isRequired, limit));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_6862<class_1792> tag) {
        return this.withAuxiliaryIngredient(tag, false, 1);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_6862<class_1792> tag, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of(tag), isRequired, limit));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_1856 ingredient) {
        return this.withAuxiliaryIngredient(ingredient, false, 1);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(class_1856 ingredient, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(ingredient, isRequired, limit));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(AuxiliaryIngredient<?> ingredient) {
        this.auxiliaryIngredients.add(Objects.requireNonNull(ingredient, "ingredient"));
        return this;
    }

    public GenericRecipe build() {
        RegularIngredient[] ingredients = new RegularIngredient[this.width * this.height];
        int output = -1;
        for (int i = 0; i < this.shape.length; ++i) {
            char key = this.shape[i];
            RegularIngredient ingredient = this.ingredients.get(Character.valueOf(key));
            if (ingredient == null) {
                if (key != ' ') {
                    throw new IllegalArgumentException("An ingredient is missing for the shape, \"" + key + "\"");
                }
                ingredient = GenericRecipe.EMPTY;
            }
            ingredients[i] = ingredient;
            if (output != -1 || key != this.outputChar) continue;
            output = i;
        }
        AuxiliaryIngredient[] auxiliaryIngredients = this.auxiliaryIngredients.toArray(new AuxiliaryIngredient[0]);
        return new GenericRecipe(this.name, this.serializer, this.output, ingredients, auxiliaryIngredients, this.width, this.height, output);
    }

    private static RegularIngredient asIngredient(Object object) {
        if (object instanceof class_1792) {
            return new BasicRegularIngredient(class_1856.method_8091((class_1935[])new class_1935[]{(class_1792)object}));
        }
        if (object instanceof class_2248) {
            return new BasicRegularIngredient(class_1856.method_8091((class_1935[])new class_1935[]{(class_2248)object}));
        }
        if (object instanceof class_1799) {
            return new BasicRegularIngredient(class_1856.method_8101((class_1799[])new class_1799[]{(class_1799)object}));
        }
        if (object instanceof class_6862) {
            return new BasicRegularIngredient(LazyTagIngredient.of((class_6862<class_1792>)((class_6862)object)));
        }
        if (object instanceof RegularIngredient) {
            return (RegularIngredient)object;
        }
        throw new IllegalArgumentException("Unknown ingredient object: " + object);
    }
}

