/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.model.light;

import de.lucalabs.fairylights.feature.light.BrightnessLightBehavior;
import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.model.light.EasyMeshBuilder;
import de.lucalabs.fairylights.model.light.LightModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5607;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class IncandescentLightModel
extends LightModel<BrightnessLightBehavior> {
    final class_630 bulb;
    final class_630 filament;

    public IncandescentLightModel(class_630 root) {
        super(root);
        this.bulb = root.method_32086("bulb");
        this.filament = root.method_32086("filament");
    }

    @Override
    public void animate(Light<?> light, BrightnessLightBehavior behavior, float delta) {
        super.animate(light, behavior, delta);
        this.brightness = behavior.getBrightness(delta);
    }

    @Override
    protected int getLight(int packedLight) {
        return (int)Math.max(this.brightness * 15.0f * 16.0f, (float)(packedLight & 0xFF)) | packedLight & 0xFF0000;
    }

    @Override
    public void method_2828(class_4587 matrix, class_4588 builder, int light, int overlay, float r, float g, float b, float a) {
        super.method_2828(matrix, builder, light, overlay, r, g, b, a);
        int emissiveLight = this.getLight(light);
        float cr = 0.23f;
        float cg = 0.18f;
        float cb = 0.14f;
        float br = this.brightness;
        this.filament.method_22699(matrix, builder, emissiveLight, overlay, r * (0.23f * (1.0f - br) + br), g * (0.18f * (1.0f - br) + br), b * (0.14f * (1.0f - br) + br), a);
    }

    @Override
    public void renderTranslucent(class_4587 matrix, class_4588 builder, int light, int overlay, float r, float g, float b, float a) {
        float bi = this.brightness;
        int emissiveLight = this.getLight(light);
        float br = 1.0f;
        float bg = 0.73f;
        float bb = 0.3f;
        this.bulb.method_22699(matrix, builder, emissiveLight, overlay, r * (1.0f * bi + (1.0f - bi)), g * (0.73f * bi + (1.0f - bi)), b * (0.3f * bi + (1.0f - bi)), bi * 0.4f + 0.25f);
        super.renderTranslucent(matrix, builder, light, overlay, r, g, b, a);
    }

    public static class_5607 createLayer() {
        LightModel.LightMeshHelper helper = LightModel.LightMeshHelper.create();
        helper.unlit().setTextureOffset(90, 10);
        helper.unlit().addBox(-1.0f, -0.01f, -1.0f, 2.0f, 1.0f, 2.0f);
        EasyMeshBuilder bulb = new EasyMeshBuilder("bulb", 98, 10);
        bulb.addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f);
        helper.extra().add(bulb);
        EasyMeshBuilder filament = new EasyMeshBuilder("filament", 90, 13);
        filament.addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f);
        helper.extra().add(filament);
        return helper.build();
    }
}

