/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.model.light;

import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.feature.light.LightBehavior;
import de.lucalabs.fairylights.model.light.EasyMeshBuilder;
import de.lucalabs.fairylights.util.BoxBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public abstract class LightModel<T extends LightBehavior>
extends class_3879 {
    protected final class_630 lit;
    protected final class_630 litTint;
    protected final class_630 litTintGlow;
    protected final class_630 unlit;
    protected float brightness = 1.0f;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    @Nullable
    private class_238 bounds;
    private double floorOffset = Double.NaN;
    private boolean powered;

    public LightModel(class_630 root) {
        super(class_1921::method_23580);
        this.lit = root.method_32086("lit");
        this.litTint = root.method_32086("lit_tint");
        this.litTintGlow = root.method_32086("lit_tint_glow");
        this.unlit = root.method_32086("unlit");
    }

    public class_238 getBounds() {
        if (this.bounds == null) {
            class_4587 matrix = new class_4587();
            BoxVertexBuilder builder = new BoxVertexBuilder();
            this.method_2828(matrix, builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.renderTranslucent(matrix, builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.bounds = builder.build();
        }
        return this.bounds;
    }

    public double getFloorOffset() {
        if (Double.isNaN(this.floorOffset)) {
            BoxVertexBuilder builder = new BoxVertexBuilder();
            this.method_2828(new class_4587(), builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.floorOffset = builder.build().field_1322 - this.getBounds().field_1322;
        }
        return this.floorOffset;
    }

    public void animate(Light<?> light, T behavior, float delta) {
        this.powered = light.isPowered();
    }

    public void method_2828(class_4587 matrix, class_4588 builder, int light, int overlay, float r, float g, float b, float a) {
        this.unlit.method_22699(matrix, builder, light, overlay, r, g, b, a);
        int emissiveLight = this.getLight(light);
        this.lit.method_22699(matrix, builder, emissiveLight, overlay, r, g, b, a);
        this.litTint.method_22699(matrix, builder, emissiveLight, overlay, r * this.red, g * this.green, b * this.blue, a);
    }

    public void renderTranslucent(class_4587 matrix, class_4588 builder, int light, int overlay, float r, float g, float b, float a) {
        float v = this.brightness;
        this.litTintGlow.method_22699(matrix, builder, this.getLight(light), overlay, r * this.red * v + (1.0f - v), g * this.green * v + (1.0f - v), b * this.blue * v + (1.0f - v), v * 0.15f + 0.2f);
    }

    protected int getLight(int packedLight) {
        return (int)Math.max(this.brightness * 15.0f * 16.0f, this.powered ? 0.0f : (float)(packedLight & 0xFF)) | packedLight & 0xFF0000;
    }

    protected static float[] toEuler(Quaternionf q) {
        float r11 = 2.0f * (q.x() * q.y() + q.w() * q.z());
        float r12 = q.w() * q.w() + q.x() * q.x() - q.y() * q.y() - q.z() * q.z();
        float r21 = -2.0f * (q.x() * q.z() - q.w() * q.y());
        float r31 = 2.0f * (q.y() * q.z() + q.w() * q.x());
        float r32 = q.w() * q.w() - q.x() * q.x() - q.y() * q.y() + q.z() * q.z();
        return new float[]{(float)class_3532.method_15349((double)r31, (double)r32), (float)Math.asin(r21), (float)class_3532.method_15349((double)r11, (double)r12)};
    }

    @Environment(value=EnvType.CLIENT)
    static class BoxVertexBuilder
    implements class_4588 {
        final BoxBuilder builder = new BoxBuilder();

        BoxVertexBuilder() {
        }

        public class_4588 method_22912(double x, double y, double z) {
            this.builder.include(x, y, z);
            return this;
        }

        public class_4588 method_1336(int r, int g, int b, int a) {
            return this;
        }

        public class_4588 method_22913(float u, float v) {
            return this;
        }

        public class_4588 method_22917(int u, int v) {
            return this;
        }

        public class_4588 method_22921(int u, int v) {
            return this;
        }

        public class_4588 method_22914(float x, float y, float z) {
            return this;
        }

        public void method_1344() {
        }

        public void method_22901(int r, int g, int b, int a) {
        }

        public void method_35666() {
        }

        class_238 build() {
            return this.builder.build();
        }
    }

    @Environment(value=EnvType.CLIENT)
    static interface ModelPartFactory {
        public EasyMeshBuilder create(String var1, int var2, int var3);
    }

    @Environment(value=EnvType.CLIENT)
    static class BulbBuilder {
        EasyMeshBuilder base;
        EasyMeshBuilder glow;

        public BulbBuilder(EasyMeshBuilder base, EasyMeshBuilder glow) {
            this.base = base;
            this.glow = glow;
        }

        public BulbBuilder setUV(int u, int v) {
            this.base.setTextureOffset(u, v);
            this.glow.setTextureOffset(u, v);
            return this;
        }

        void addBox(float x, float y, float z, float width, float height, float depth) {
            this.addBox(x, y, z, width, height, depth, 0.0f);
        }

        void addBox(float x, float y, float z, float width, float height, float depth, float expand) {
            this.addBox(x, y, z, width, height, depth, expand, 0.7f);
        }

        void addBox(float x, float y, float z, float width, float height, float depth, float expand, float glow) {
            this.base.addBox(x, y, z, width, height, depth, expand);
            this.glow.addBox(x, y, z, width, height, depth, expand + glow);
        }

        BulbBuilder createChild(String name, int u, int v) {
            return this.createChild(name, u, v, EasyMeshBuilder::new);
        }

        BulbBuilder createChild(String name, int u, int v, ModelPartFactory factory) {
            EasyMeshBuilder base = factory.create(name, u, v);
            EasyMeshBuilder glow = factory.create(name, u, v);
            this.base.addChild(base);
            this.glow.addChild(glow);
            return new BulbBuilder(base, glow);
        }

        public void setPosition(float x, float y, float z) {
            this.base.setRotationPoint(x, y, z);
            this.glow.setRotationPoint(x, y, z);
        }

        public void setAngles(float x, float y, float z) {
            this.base.xRot = x;
            this.base.yRot = y;
            this.base.zRot = z;
            this.glow.xRot = x;
            this.glow.yRot = y;
            this.glow.zRot = z;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record LightMeshHelper(EasyMeshBuilder lit, EasyMeshBuilder litTint, EasyMeshBuilder litTintGlow, EasyMeshBuilder unlit, List<EasyMeshBuilder> extra) {
        BulbBuilder createBulb() {
            return new BulbBuilder(this.litTint(), this.litTintGlow());
        }

        public class_5607 build() {
            class_5609 def = new class_5609();
            this.lit().build(def.method_32111());
            this.litTint().build(def.method_32111());
            this.litTintGlow().build(def.method_32111());
            this.unlit().build(def.method_32111());
            for (EasyMeshBuilder builder : this.extra()) {
                builder.build(def.method_32111());
            }
            return class_5607.method_32110((class_5609)def, (int)128, (int)128);
        }

        public EasyMeshBuilder parented(String name) {
            EasyMeshBuilder result = new EasyMeshBuilder(name);
            result.addChild(this.lit());
            result.addChild(this.litTint());
            result.addChild(this.litTintGlow());
            result.addChild(this.unlit());
            for (EasyMeshBuilder builder : this.extra()) {
                result.addChild(builder);
            }
            return result;
        }

        public static LightMeshHelper create() {
            EasyMeshBuilder lit = new EasyMeshBuilder("lit");
            EasyMeshBuilder litTint = new EasyMeshBuilder("lit_tint");
            EasyMeshBuilder litTintGlow = new EasyMeshBuilder("lit_tint_glow");
            EasyMeshBuilder unlit = new EasyMeshBuilder("unlit");
            return new LightMeshHelper(lit, litTint, litTintGlow, unlit, new ArrayList<EasyMeshBuilder>());
        }
    }
}

