/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.net.serverbound;

import de.lucalabs.fairylights.collision.Intersection;
import de.lucalabs.fairylights.connection.Connection;
import de.lucalabs.fairylights.connection.PlayerAction;
import de.lucalabs.fairylights.feature.FeatureType;
import de.lucalabs.fairylights.net.ConnectionMessage;
import de.lucalabs.fairylights.util.Utils;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class InteractionConnectionMessage
extends ConnectionMessage {
    public static final class_2960 ID = new class_2960("fairylights", "interaction_connection");
    private static final float RANGE = 1089.0f;
    private static final float REACH = 36.0f;

    public InteractionConnectionMessage(Connection connection, PlayerAction type, Intersection intersection) {
        super(connection);
        class_243 hit = intersection.result();
        this.writeByte(type.ordinal());
        this.writeDouble(hit.field_1352);
        this.writeDouble(hit.field_1351);
        this.writeDouble(hit.field_1350);
        this.method_10804(intersection.featureType().getId());
        this.method_10804(intersection.feature().getId());
    }

    public static void apply(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ConnectionMessage.ParsedData baseData = InteractionConnectionMessage.parse(buf);
        short type = buf.readUnsignedByte();
        PlayerAction action = Utils.getEnumValue(PlayerAction.class, type);
        double hitX = buf.readDouble();
        double hitY = buf.readDouble();
        double hitZ = buf.readDouble();
        class_243 hit = new class_243(hitX, hitY, hitZ);
        FeatureType featureType = FeatureType.fromId(buf.method_10816());
        int featureId = buf.method_10816();
        server.execute(() -> InteractionConnectionMessage.getConnection(baseData.accessor(), baseData.id(), c -> true, player.method_37908()).ifPresent(connection -> {
            if (connection.isModifiable((class_1657)player) && player.method_5707(class_243.method_24954((class_2382)connection.getFastener().getPos())) < 1089.0 && player.method_5649(hitX, hitY, hitZ) < 36.0) {
                if (action == PlayerAction.ATTACK) {
                    connection.disconnect((class_1657)player, hit);
                } else {
                    InteractionConnectionMessage.interact((class_1657)player, connection, featureType, featureId, hit);
                }
            }
        }));
    }

    private static void interact(class_1657 player, Connection connection, FeatureType featureType, int featureId, class_243 hit) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 stack = player.method_5998(hand);
            class_1799 oldStack = stack.method_7972();
            if (!connection.interact(player, hit, featureType, featureId, stack, hand)) continue;
            InteractionConnectionMessage.updateItem(player, oldStack, stack, hand);
            break;
        }
    }

    private static void updateItem(class_1657 player, class_1799 oldStack, class_1799 stack, class_1268 hand) {
        if (stack.method_7947() <= 0 && !player.method_31549().field_7477) {
            player.method_6122(hand, class_1799.field_8037);
        } else if (stack.method_7947() < oldStack.method_7947() && player.method_31549().field_7477) {
            stack.method_7939(oldStack.method_7947());
        }
    }
}

