/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.renderer.block.entity;

import de.lucalabs.fairylights.connection.HangingLightsConnection;
import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.items.SimpleLightVariant;
import de.lucalabs.fairylights.renderer.FairyLightModelLayers;
import de.lucalabs.fairylights.renderer.block.entity.ConnectionRenderer;
import de.lucalabs.fairylights.renderer.block.entity.LightRenderer;
import de.lucalabs.fairylights.util.MathHelper;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_630;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class HangingLightsRenderer
extends ConnectionRenderer<HangingLightsConnection> {
    private final LightRenderer lights;

    public HangingLightsRenderer(Function<class_5601, class_630> baker) {
        super(baker, FairyLightModelLayers.LIGHTS_WIRE);
        this.lights = new LightRenderer(baker);
    }

    @Override
    protected int getWireColor(HangingLightsConnection conn) {
        return conn.getString().color();
    }

    @Override
    public void render(HangingLightsConnection conn, float delta, class_4587 matrix, class_4597 source, int packedLight, int packedOverlay) {
        super.render(conn, delta, matrix, source, packedLight, packedOverlay);
        Light[] lights = (Light[])conn.getFeatures();
        if (lights == null) {
            return;
        }
        LightRenderer.Data data = this.lights.start(source);
        for (int i = 0; i < lights.length; ++i) {
            Light light = lights[i];
            class_243 pos = light.getPoint(delta);
            matrix.method_22903();
            matrix.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
            matrix.method_22907(class_7833.field_40716.rotation(-light.getYaw(delta)));
            if (light.parallelsCord()) {
                matrix.method_22907(class_7833.field_40718.rotation(light.getPitch(delta)));
            }
            matrix.method_22907(class_7833.field_40714.rotation(light.getRoll(delta)));
            if (light.getVariant() != SimpleLightVariant.FAIRY_LIGHT) {
                matrix.method_22907(class_7833.field_40716.rotation(MathHelper.mod((float)MathHelper.hash(i) * ((float)Math.PI / 180), (float)Math.PI * 2) + 0.7853982f));
            }
            matrix.method_22904(0.0, (double)(-light.getDescent()), 0.0);
            this.lights.render(matrix, data, light, i, delta, packedLight, packedOverlay);
            matrix.method_22909();
        }
    }

    public static class_5607 wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(0, 0, 2);
    }
}

