/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.renderer.block.entity;

import com.google.common.collect.ImmutableMap;
import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.feature.light.LightBehavior;
import de.lucalabs.fairylights.items.LightVariant;
import de.lucalabs.fairylights.items.SimpleLightVariant;
import de.lucalabs.fairylights.model.light.FairyLightModel;
import de.lucalabs.fairylights.model.light.IncandescentLightModel;
import de.lucalabs.fairylights.model.light.LightModel;
import de.lucalabs.fairylights.model.light.OilLanternModel;
import de.lucalabs.fairylights.renderer.FairyLightModelLayers;
import de.lucalabs.fairylights.renderer.RenderConstants;
import de.lucalabs.fairylights.renderer.block.entity.ForwardingVertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class LightRenderer {
    private final LightModelProvider<LightBehavior> defaultLight = LightModelProvider.of(new DefaultModel());
    private final Map<LightVariant<?>, LightModelProvider<?>> lights;

    public LightRenderer(Function<class_5601, class_630> baker) {
        this.lights = new ImmutableMap.Builder().put(SimpleLightVariant.FAIRY_LIGHT, LightModelProvider.of(new FairyLightModel(baker.apply(FairyLightModelLayers.FAIRY_LIGHT)))).put(SimpleLightVariant.INCANDESCENT_LIGHT, LightModelProvider.of(new IncandescentLightModel(baker.apply(FairyLightModelLayers.INCANDESCENT_LIGHT)))).put(SimpleLightVariant.OIL_LANTERN, LightModelProvider.of(new OilLanternModel(baker.apply(FairyLightModelLayers.OIL_LANTERN)))).build();
    }

    public Data start(class_4597 source) {
        final class_4588 buf = RenderConstants.TRANSLUCENT_TEXTURE.method_24145(source, class_1921::method_23580);
        ForwardingVertexConsumer translucent = new ForwardingVertexConsumer(){

            @Override
            protected class_4588 delegate() {
                return buf;
            }

            @Override
            public class_4588 method_22914(float x, float y, float z) {
                return super.method_22914(0.0f, 1.0f, 0.0f);
            }
        };
        return new Data(buf, translucent);
    }

    public <T extends LightBehavior> LightModel<T> getModel(Light<?> light, int index) {
        return this.getModel(light.getVariant(), index);
    }

    public <T extends LightBehavior> LightModel<T> getModel(LightVariant<?> variant, int index) {
        return this.lights.getOrDefault(variant, this.defaultLight).get(index);
    }

    public void render(class_4587 matrix, Data data, Light<?> light, int index, float delta, int packedLight, int packedOverlay) {
        this.render(matrix, data, light, this.getModel(light, index), delta, packedLight, packedOverlay);
    }

    public <T extends LightBehavior> void render(class_4587 matrix, Data data, Light<T> light, LightModel<T> model, float delta, int packedLight, int packedOverlay) {
        model.animate(light, light.getBehavior(), delta);
        model.method_2828(matrix, data.solid, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        model.renderTranslucent(matrix, data.translucent, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Environment(value=EnvType.CLIENT)
    static class DefaultModel
    extends LightModel<LightBehavior> {
        private static final class_630 EMPTY = new class_630(List.of(), Map.of());

        public DefaultModel() {
            super(new class_630(List.of(), Map.of("lit", EMPTY, "lit_tint", EMPTY, "lit_tint_glow", EMPTY, "unlit", EMPTY)));
        }

        @Override
        public void method_2828(class_4587 matrix, class_4588 builder, int light, int overlay, float r, float g, float b, float a) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    static interface LightModelProvider<T extends LightBehavior> {
        public LightModel<T> get(int var1);

        public static <T extends LightBehavior> LightModelProvider<T> of(LightModel<T> model) {
            return i -> model;
        }

        public static <T extends LightBehavior> LightModelProvider<T> of(Supplier<LightModel<T>> model) {
            return i -> (LightModel)((Object)((Object)model.get()));
        }

        public static <T extends LightBehavior, D> LightModelProvider<T> of(D data, BiFunction<? super D, Integer, LightModel<T>> function) {
            return i -> (LightModel)((Object)((Object)function.apply((Object)data, i)));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Data(class_4588 solid, class_4588 translucent) {
    }
}

