/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.util;

import com.google.common.base.Preconditions;
import de.lucalabs.fairylights.util.MathHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public final class BoxBuilder {
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;

    public BoxBuilder() {
    }

    public BoxBuilder(class_2338 pos) {
        Objects.requireNonNull(pos, "pos");
        this.minX = pos.method_10263();
        this.maxX = this.minX + 1.0;
        this.minY = pos.method_10264();
        this.maxY = this.minY + 1.0;
        this.minZ = pos.method_10260();
        this.maxZ = this.minZ + 1.0;
    }

    public BoxBuilder(class_243 min, class_243 max) {
        this(Objects.requireNonNull(min, (String)"min").field_1352, min.field_1351, min.field_1350, Objects.requireNonNull(max, (String)"max").field_1352, max.field_1351, max.field_1350);
    }

    public BoxBuilder(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public BoxBuilder add(class_243 point) {
        return this.add(Objects.requireNonNull(point, (String)"point").field_1352, point.field_1351, point.field_1350);
    }

    public BoxBuilder add(class_2382 point) {
        return this.add(Objects.requireNonNull(point, "point").method_10263(), point.method_10264(), point.method_10260());
    }

    public BoxBuilder add(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public BoxBuilder include(class_243 point) {
        return this.include(Objects.requireNonNull(point, (String)"point").field_1352, point.field_1351, point.field_1350);
    }

    public BoxBuilder include(double x, double y, double z) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        return this;
    }

    public BoxBuilder expand(double amount) {
        this.minX -= amount;
        this.minY -= amount;
        this.minZ -= amount;
        this.maxX += amount;
        this.maxY += amount;
        this.maxZ += amount;
        return this;
    }

    public class_238 build() {
        return new class_238(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public static class_238 union(List<class_238> boxes) {
        Objects.requireNonNull(boxes, "Boxes");
        return BoxBuilder.union(boxes, box -> box);
    }

    public static <T> class_238 union(List<T> boxes, Function<T, class_238> mapper) {
        Objects.requireNonNull(boxes, "Boxes");
        Objects.requireNonNull(mapper, "mapper");
        Preconditions.checkArgument((!boxes.isEmpty() ? 1 : 0) != 0, (Object)"Must have more than zero Boxs");
        class_238 bounds = mapper.apply(boxes.get(0));
        if (boxes.size() == 1) {
            return Objects.requireNonNull(bounds, "mapper returned bounds");
        }
        double minX = bounds.field_1323;
        double minY = bounds.field_1322;
        double minZ = bounds.field_1321;
        double maxX = bounds.field_1320;
        double maxY = bounds.field_1325;
        double maxZ = bounds.field_1324;
        int size = boxes.size();
        for (int i = 1; i < size; ++i) {
            bounds = Objects.requireNonNull(mapper.apply(boxes.get(i)), "mapper returned bounds");
            minX = MathHelper.min(minX, bounds.field_1323, bounds.field_1320);
            minY = MathHelper.min(minY, bounds.field_1322, bounds.field_1325);
            minZ = MathHelper.min(minZ, bounds.field_1321, bounds.field_1324);
            maxX = MathHelper.max(maxX, bounds.field_1323, bounds.field_1320);
            maxY = MathHelper.max(maxY, bounds.field_1322, bounds.field_1325);
            maxZ = MathHelper.max(maxZ, bounds.field_1321, bounds.field_1324);
        }
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

