/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.util;

import de.lucalabs.fairylights.util.CatenaryUtils;
import de.lucalabs.fairylights.util.CubicBezier;
import de.lucalabs.fairylights.util.Curve;
import de.lucalabs.fairylights.util.MathHelper;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public final class Catenary
implements Curve {
    private static final int MIN_VERTEX_COUNT = 8;
    private final int count;
    private final float yaw;
    private final float dx;
    private final float dz;
    private final float[] x;
    private final float[] y;
    private final float length;

    private Catenary(int count, float yaw, float dx, float dz, float[] x, float[] y, float length) {
        this.count = count;
        this.yaw = yaw;
        this.dx = dx;
        this.dz = dz;
        this.x = x;
        this.y = y;
        this.length = length;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public float getX() {
        return this.x[this.count - 1] * this.dx;
    }

    @Override
    public float getY() {
        return this.y[this.count - 1];
    }

    @Override
    public float getZ() {
        return this.x[this.count - 1] * this.dz;
    }

    @Override
    public float getX(int i) {
        return this.x[i] * this.dx;
    }

    @Override
    public float getX(int i, float t) {
        return class_3532.method_16439((float)t, (float)this.x[i], (float)this.x[i + 1]) * this.dx;
    }

    @Override
    public float getY(int i) {
        return this.y[i];
    }

    @Override
    public float getY(int i, float t) {
        return class_3532.method_16439((float)t, (float)this.y[i], (float)this.y[i + 1]);
    }

    @Override
    public float getZ(int i) {
        return this.x[i] * this.dz;
    }

    @Override
    public float getZ(int i, float t) {
        return class_3532.method_16439((float)t, (float)this.x[i], (float)this.x[i + 1]) * this.dz;
    }

    @Override
    public float getDx(int i) {
        return (this.x[i + 1] - this.x[i]) * this.dx;
    }

    @Override
    public float getDy(int i) {
        return this.y[i + 1] - this.y[i];
    }

    @Override
    public float getDz(int i) {
        return (this.x[i + 1] - this.x[i]) * this.dz;
    }

    @Override
    public float getLength() {
        return this.length;
    }

    @Override
    public Curve.SegmentIterator iterator() {
        return this.iterator(false);
    }

    @Override
    public Curve lerp(Curve curve, float delta) {
        if (this == curve) {
            return this;
        }
        if (curve.getClass() != this.getClass()) {
            return curve;
        }
        Catenary other = (Catenary)curve;
        if (this.count > other.count) {
            return other.lerp(this, 1.0f - delta);
        }
        float[] nx = new float[this.count];
        float[] ny = new float[this.count];
        for (int i = 0; i < this.count; ++i) {
            boolean end = this.count != other.count && i == this.count - 1;
            nx[i] = class_3532.method_16439((float)delta, (float)this.x[i], (float)other.x[end ? other.count - 1 : i]);
            ny[i] = class_3532.method_16439((float)delta, (float)this.y[i], (float)other.y[end ? other.count - 1 : i]);
        }
        float angle = MathHelper.lerpAngle(this.yaw, other.yaw, delta);
        float vx = class_3532.method_15362((float)angle);
        float vz = class_3532.method_15374((float)angle);
        return new Catenary(this.count, angle, vx, vz, nx, ny, class_3532.method_16439((float)delta, (float)this.length, (float)other.length));
    }

    @Override
    public void visitPoints(float spacing, boolean center, Curve.PointVisitor visitor) {
        float distance = center ? (this.length % spacing + spacing) / 2.0f : 0.0f;
        int index = 0;
        Curve.SegmentIterator it = this.iterator();
        while (it.next()) {
            float length = it.getLength();
            while (distance < length) {
                float t = distance / length;
                visitor.visit(index++, it.getX(t), it.getY(t), it.getZ(t), it.getYaw(), it.getPitch());
                distance += spacing;
            }
            distance -= length;
            if (center || it.hasNext()) continue;
            visitor.visit(index++, it.getX(1.0f), it.getY(1.0f), it.getZ(1.0f), it.getYaw(), it.getPitch());
        }
    }

    @Override
    public Curve.SegmentIterator iterator(boolean inclusive) {
        return new Curve.CurveSegmentIterator<Catenary>(this, inclusive){

            @Override
            public float getYaw() {
                return ((Catenary)this.curve).yaw;
            }

            @Override
            protected float getPitch(int index) {
                float dx = ((Catenary)this.curve).x[index + 1] - ((Catenary)this.curve).x[index];
                float dy = ((Catenary)this.curve).y[index + 1] - ((Catenary)this.curve).y[index];
                return (float)class_3532.method_15349((double)dy, (double)dx);
            }

            @Override
            public float getLength(int index) {
                float dx = ((Catenary)this.curve).x[index + 1] - ((Catenary)this.curve).x[index];
                float dy = ((Catenary)this.curve).y[index + 1] - ((Catenary)this.curve).y[index];
                return class_3532.method_15355((float)(dx * dx + dy * dy));
            }
        };
    }

    public static Catenary from(class_243 direction, float verticalYaw, CubicBezier bezier, float slack) {
        float dist = (float)direction.method_1033();
        float length = (double)slack < 0.01 || Math.abs(direction.field_1352) < 1.0E-6 && Math.abs(direction.field_1350) < 1.0E-6 ? dist : dist + (Catenary.lengthFunc(bezier, dist) - dist) * slack;
        return Catenary.from(direction, verticalYaw, length);
    }

    private static float lengthFunc(CubicBezier bezier, double length) {
        return bezier.eval(class_3532.method_15363((float)((float)length / 32.0f), (float)0.0f, (float)1.0f)) * 32.0f;
    }

    public static Catenary from(class_243 dir, float verticalYaw, float ropeLength) {
        float endX = class_3532.method_15355((float)((float)(dir.field_1352 * dir.field_1352 + dir.field_1350 * dir.field_1350)));
        float endY = (float)dir.field_1351;
        float angle = endX < 0.001f ? (endY < 0.0f ? verticalYaw + (float)Math.PI : verticalYaw) : (float)class_3532.method_15349((double)dir.field_1350, (double)dir.field_1352);
        float vx = class_3532.method_15362((float)angle);
        float vz = class_3532.method_15374((float)angle);
        if (dir.method_1033() > 64.0) {
            return new Catenary(2, angle, vx, vz, new float[]{0.0f, endX}, new float[]{0.0f, endY}, class_3532.method_15355((float)(endX * endX + endY * endY)));
        }
        int count = Math.max((int)(ropeLength * 3.0f), 8);
        float[] x = new float[count];
        float[] y = new float[count];
        CatenaryUtils.catenary(0.0f, 0.0f, endX, endY, ropeLength, count, x, y);
        float length = 0.0f;
        for (int i = 1; i < count; ++i) {
            float dx = x[i] - x[i - 1];
            float dy = y[i] - y[i - 1];
            length += class_3532.method_15355((float)(dx * dx + dy * dy));
        }
        return new Catenary(count, angle, vx, vz, x, y, length);
    }
}

