/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.util;

import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.class_243;

public final class MathHelper {
    public static final float PI = (float)Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final float TAU = (float)Math.PI * 2;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.29578f;

    private MathHelper() {
    }

    public static int mod(int a, int b) {
        return (a % b + b) % b;
    }

    public static float mod(float a, float b) {
        return (a % b + b) % b;
    }

    public static double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public static float transform(float x, float domainMin, float domainMax, float rangeMin, float rangeMax) {
        if (x <= domainMin) {
            return rangeMin;
        }
        if (x >= domainMax) {
            return rangeMax;
        }
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }

    public static double transform(double x, double domainMin, double domainMax, double rangeMin, double rangeMax) {
        if (x <= domainMin) {
            return rangeMin;
        }
        if (x >= domainMax) {
            return rangeMax;
        }
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }

    public static int hash(int x) {
        x = (x >> 16 ^ x) * 73244475;
        x = (x >> 16 ^ x) * 73244475;
        x = x >> 16 ^ x;
        return x;
    }

    public static class_243 lerp(class_243 a, class_243 b, double t) {
        Objects.requireNonNull(a, "a vector");
        Objects.requireNonNull(b, "b vector");
        double x = a.field_1352 + (b.field_1352 - a.field_1352) * t;
        double y = a.field_1351 + (b.field_1351 - a.field_1351) * t;
        double z = a.field_1350 + (b.field_1350 - a.field_1350) * t;
        return new class_243(x, y, z);
    }

    public static float lerpAngle(float a, float b, float t) {
        return a + t * MathHelper.angleDifference(a, b);
    }

    public static float lerpMod(float a, float b, float t, float n) {
        return a + t * MathHelper.modularDifference(a, b, n);
    }

    public static float modularDifference(float a, float b, float n) {
        return MathHelper.mod(b - a + n * 0.5f, n) - n * 0.5f;
    }

    public static float angleDifference(float a, float b) {
        return MathHelper.mod(b - a + (float)Math.PI, (float)Math.PI * 2) - (float)Math.PI;
    }

    public static int floorInterval(int x, int n) {
        return x / n * n;
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static int log2(int n) {
        if (n <= 0) {
            throw new ArithmeticException("Negative infinity: " + n);
        }
        int r = 0;
        while ((n >>= 1) > 0) {
            ++r;
        }
        return r;
    }

    public static int lcm(int a, int b) {
        return Math.abs(a * b) / MathHelper.gcd(a, b);
    }

    public static int gcd(int a, int b) {
        while (b != 0) {
            int n = a;
            a = b;
            b = MathHelper.mod(n, a);
        }
        return a;
    }

    public static double angle(class_243 a, class_243 b) {
        Objects.requireNonNull(a, "a vector");
        Objects.requireNonNull(b, "b vector");
        double theta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        if (theta > 1.0) {
            return 0.0;
        }
        if (theta < -1.0) {
            return Math.PI;
        }
        return Math.acos(theta);
    }

    public static <T> int[] invertMap(T[] map, ToIntFunction<T> asInt) {
        for (T v : map) {
            int vp = asInt.applyAsInt(v);
            if (vp >= 0 && vp < map.length) continue;
            throw new IllegalArgumentException("Must be a perfect map, " + v + " out of range with " + vp);
        }
        int[] inverse = new int[map.length];
        for (int i = 0; i < map.length; ++i) {
            inverse[asInt.applyAsInt(map[i])] = i;
        }
        return inverse;
    }
}

