/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.util.styled;

import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;

public final class Style
implements Comparable<Style> {
    private static final int COLOR_MASK = 15;
    private static final int OBFUSCATED_MASK = 16;
    private static final int BOLD_MASK = 32;
    private static final int STRIKETHROUGH_MASK = 64;
    private static final int UNDERLINE_MASK = 128;
    private static final int ITALIC_MASK = 256;
    private static final int FANCY_MASK = 496;
    private final int value;

    public Style() {
        this(class_124.field_1068, false, false, false, false, false);
    }

    public Style(class_124 color, boolean isBold, boolean isStrikethrough, boolean isUnderline, boolean isItalic, boolean isObfuscated) {
        this(Style.pack(color, isBold, isStrikethrough, isUnderline, isItalic, isObfuscated));
    }

    public Style(int value) {
        this.value = value;
    }

    public int packed() {
        return this.value;
    }

    public class_124 getColor() {
        return class_124.method_534((int)(this.value & 0xF));
    }

    public boolean isObfuscated() {
        return (this.value & 0x10) != 0;
    }

    public boolean isBold() {
        return (this.value & 0x20) != 0;
    }

    public boolean isStrikethrough() {
        return (this.value & 0x40) != 0;
    }

    public boolean isUnderline() {
        return (this.value & 0x80) != 0;
    }

    public boolean isItalic() {
        return (this.value & 0x100) != 0;
    }

    public boolean isPlain() {
        return (this.value & 0x1F0) == 0;
    }

    public Style withColor(class_124 color) {
        if (!color.method_543()) {
            throw new IllegalArgumentException("Invalid color formatting: " + color.method_537());
        }
        return new Style(color.method_536() | this.value & 0x1F0);
    }

    public Style withBold(boolean isBold) {
        return new Style(isBold ? this.value | 0x20 : this.value & 0xFFFFFFDF);
    }

    public Style withStrikethrough(boolean isStrikethrough) {
        return new Style(isStrikethrough ? this.value | 0x40 : this.value & 0xFFFFFFBF);
    }

    public Style withUnderline(boolean isUnderline) {
        return new Style(isUnderline ? this.value | 0x80 : this.value & 0xFFFFFF7F);
    }

    public Style withItalic(boolean isItalic) {
        return new Style(isItalic ? this.value | 0x100 : this.value & 0xFFFFFEFF);
    }

    public Style withObfuscated(boolean isObfuscated) {
        return new Style(isObfuscated ? this.value | 0x10 : this.value & 0xFFFFFFEF);
    }

    public Style withStyling(class_124 formatting, boolean state) {
        if (formatting.method_543()) {
            return this.withColor(formatting);
        }
        return switch (formatting) {
            case class_124.field_1067 -> this.withBold(state);
            case class_124.field_1055 -> this.withStrikethrough(state);
            case class_124.field_1073 -> this.withUnderline(state);
            case class_124.field_1056 -> this.withItalic(state);
            case class_124.field_1051 -> this.withObfuscated(state);
            default -> throw new IllegalArgumentException("Invalid fancy formatting: " + formatting.method_537());
        };
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Style && this.value == ((Style)obj).value;
    }

    @Override
    public int compareTo(@NotNull Style other) {
        if (this == other) {
            return 0;
        }
        return this.value - other.value;
    }

    private static int pack(class_124 color, boolean isBold, boolean isStrikethrough, boolean isUnderline, boolean isItalic, boolean isObfuscated) {
        if (!color.method_543()) {
            throw new IllegalArgumentException("Invalid color formatting: " + color.method_537());
        }
        int value = color.method_536();
        if (isObfuscated) {
            value |= 0x10;
        }
        if (isBold) {
            value |= 0x20;
        }
        if (isStrikethrough) {
            value |= 0x40;
        }
        if (isUnderline) {
            value |= 0x80;
        }
        if (isItalic) {
            value |= 0x100;
        }
        return value;
    }
}

