/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.util.styled;

import de.lucalabs.fairylights.util.styled.Style;
import de.lucalabs.fairylights.util.styled.StyledString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class StyledStringBuilder
implements Appendable,
CharSequence {
    private final StringBuilder stringBuilder;
    private final List<Style> styling;
    private Style currentStyle;

    public StyledStringBuilder(String str) {
        this();
        this.append(str);
    }

    public StyledStringBuilder() {
        this(16);
    }

    public StyledStringBuilder(int capacity) {
        this(new StringBuilder(capacity), new ArrayList<Style>(capacity), new Style());
    }

    private StyledStringBuilder(StringBuilder stringBuilder, List<Style> styling, Style currentStyle) {
        this.stringBuilder = stringBuilder;
        this.styling = styling;
        this.currentStyle = currentStyle;
    }

    public StyledStringBuilder setStyle(Style style) {
        this.currentStyle = Objects.requireNonNull(style);
        return this;
    }

    @Override
    public int length() {
        return this.stringBuilder.length();
    }

    @Override
    public char charAt(int index) {
        return this.stringBuilder.charAt(index);
    }

    @Override
    @NotNull
    public StyledStringBuilder subSequence(int start, int end) {
        return new StyledStringBuilder(new StringBuilder(this.stringBuilder.substring(start, end)), new ArrayList<Style>(this.styling).subList(start, end), this.styling.get(start));
    }

    public StyledStringBuilder insert(int index, String str) {
        this.stringBuilder.insert(0, str);
        for (int i = str.length(); i > 0; --i) {
            this.styling.add(index, this.currentStyle);
        }
        return this;
    }

    public StyledStringBuilder insert(int index, StyledString str) {
        this.stringBuilder.insert(0, str.toUnstyledString());
        Style[] styling = str.getStyling();
        for (int i = styling.length - 1; i >= 0; --i) {
            this.styling.add(index, styling[i]);
        }
        return this;
    }

    public StyledStringBuilder append(StyledString str) {
        this.stringBuilder.append(str.toUnstyledString());
        this.styling.addAll(Arrays.asList(str.getStyling()));
        return this;
    }

    public StyledStringBuilder append(CharSequence csq, Style style) {
        this.stringBuilder.append(csq);
        for (int i = 0; i < csq.length(); ++i) {
            this.styling.add(style);
        }
        return this;
    }

    @Override
    public StyledStringBuilder append(CharSequence csq) {
        this.stringBuilder.append(csq);
        for (int i = 0; i < csq.length(); ++i) {
            this.styling.add(this.currentStyle);
        }
        return this;
    }

    @Override
    public StyledStringBuilder append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public StyledStringBuilder append(char c) {
        return this.append(c, this.currentStyle);
    }

    public StyledStringBuilder append(char c, Style s) {
        this.stringBuilder.append(c);
        this.styling.add(s);
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.stringBuilder.toString();
    }

    public StyledString toStyledString() {
        return new StyledString(this.stringBuilder.toString(), this.styling.toArray(new Style[0]));
    }
}

